/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.CSSFontFaceRuleImpl;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

@JsxClass
public class CSSFontFaceRule
extends CSSRule {
    private static final Pattern REPLACEMENT_1 = Pattern.compile("font-family: ([^;]*);");
    private static final Pattern REPLACEMENT_2 = Pattern.compile("src: url\\(([^;]*)\\);");

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public CSSFontFaceRule() {
    }

    protected CSSFontFaceRule(CSSStyleSheet stylesheet, CSSFontFaceRuleImpl rule) {
        super(stylesheet, rule);
    }

    @Override
    public short getType() {
        return 5;
    }

    @Override
    public String getCssText() {
        String cssText = super.getCssText();
        BrowserVersion browserVersion = this.getBrowserVersion();
        if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_FONTFACERULE_CSSTEXT_IE_STYLE)) {
            cssText = StringUtils.replace(cssText, "{", "{\n\t");
            cssText = StringUtils.replace(cssText, "}", ";\n}\n");
            cssText = StringUtils.replace(cssText, "; ", ";\n\t");
        } else if (browserVersion.hasFeature(BrowserVersionFeatures.CSS_FONTFACERULE_CSSTEXT_CHROME_STYLE)) {
            cssText = StringUtils.replace(cssText, "{", "{ ");
            cssText = StringUtils.replace(cssText, "}", "; }");
            cssText = StringUtils.replace(cssText, "; ", "; ");
            cssText = REPLACEMENT_1.matcher(cssText).replaceFirst("font-family: $1;");
            cssText = REPLACEMENT_2.matcher(cssText).replaceFirst("src: url(\"$1\");");
        } else {
            cssText = StringUtils.replace(cssText, "{", "{\n  ");
            cssText = StringUtils.replace(cssText, "}", ";\n}");
            cssText = StringUtils.replace(cssText, "; ", ";\n  ");
            cssText = REPLACEMENT_1.matcher(cssText).replaceFirst("font-family: $1;");
            cssText = REPLACEMENT_2.matcher(cssText).replaceFirst("src: url(\"$1\");");
        }
        return cssText;
    }
}

