/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.dom.CSSStyleRuleImpl;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxSetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSRule;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleDeclaration;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import com.gargoylesoftware.htmlunit.util.StringUtils;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@JsxClass
public class CSSStyleRule
extends CSSRule {
    private static final Pattern SELECTOR_PARTS_PATTERN = Pattern.compile("[\\.#]?[a-zA-Z]+");
    private static final Pattern SELECTOR_REPLACE_PATTERN = Pattern.compile("\\*([\\.#])");

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public CSSStyleRule() {
    }

    protected CSSStyleRule(CSSStyleSheet stylesheet, CSSStyleRuleImpl rule) {
        super(stylesheet, rule);
    }

    @JsxGetter
    public String getSelectorText() {
        String selectorText = ((CSSStyleRuleImpl)this.getRule()).getSelectorText();
        Matcher m = SELECTOR_PARTS_PATTERN.matcher(selectorText);
        StringBuffer sb = new StringBuffer();
        while (m.find()) {
            String fixedName = m.group();
            if (this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_SELECTOR_TEXT_LOWERCASE) && !fixedName.isEmpty() && '.' != fixedName.charAt(0) && '#' != fixedName.charAt(0)) {
                fixedName = fixedName.toLowerCase(Locale.ROOT);
            }
            fixedName = StringUtils.sanitizeForAppendReplacement(fixedName);
            m.appendReplacement(sb, fixedName);
        }
        m.appendTail(sb);
        selectorText = SELECTOR_REPLACE_PATTERN.matcher(sb.toString()).replaceAll("$1");
        return selectorText;
    }

    @JsxSetter
    public void setSelectorText(String selectorText) {
        ((CSSStyleRuleImpl)this.getRule()).setSelectorText(selectorText);
    }

    @JsxGetter
    public CSSStyleDeclaration getStyle() {
        return new CSSStyleDeclaration(this.getParentScope(), ((CSSStyleRuleImpl)this.getRule()).getStyle());
    }

    @JsxGetter(value={SupportedBrowser.IE})
    public boolean isReadOnly() {
        return false;
    }
}

