/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitContextFactory;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventTarget;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.ContextAction;
import net.sourceforge.htmlunit.corejs.javascript.NativeObject;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;

@JsxClass
public class PopStateEvent
extends Event {
    private Object state_;

    public PopStateEvent() {
        this.setEventType("");
    }

    @Override
    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public void jsConstructor(String type, ScriptableObject details) {
        super.jsConstructor(type, details);
        if (details != null && !Undefined.isUndefined(details)) {
            this.state_ = details.get("state");
        }
    }

    public PopStateEvent(EventTarget target, String type, Object state) {
        super(target, type);
        if (state instanceof NativeObject && this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_POP_STATE_EVENT_CLONE_STATE)) {
            final NativeObject old = (NativeObject)state;
            final NativeObject newState = new NativeObject();
            WebClient client = this.getWindow().getWebWindow().getWebClient();
            HtmlUnitContextFactory cf = ((JavaScriptEngine)client.getJavaScriptEngine()).getContextFactory();
            ContextAction<Object> contextAction = new ContextAction<Object>(){

                @Override
                public Object run(Context cx) {
                    for (Object o : ScriptableObject.getPropertyIds(old)) {
                        String property = Context.toString(o);
                        newState.defineProperty(property, ScriptableObject.getProperty((Scriptable)old, property), 0);
                    }
                    return null;
                }
            };
            cf.call(contextAction);
            this.state_ = newState;
        } else {
            this.state_ = state;
        }
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void initPopStateEvent(String type, boolean bubbles, boolean cancelable, Object state) {
        this.initEvent(type, bubbles, cancelable);
        this.state_ = state;
    }

    @JsxGetter
    public Object getState() {
        return this.state_;
    }

    @Override
    public void put(String name, Scriptable start, Object value) {
        if (!"state".equals(name)) {
            super.put(name, start, value);
        }
    }
}

