/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.file;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.file.Blob;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sourceforge.htmlunit.corejs.javascript.NativeArray;
import net.sourceforge.htmlunit.corejs.javascript.ScriptRuntime;
import net.sourceforge.htmlunit.corejs.javascript.ScriptableObject;
import net.sourceforge.htmlunit.corejs.javascript.Undefined;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.FastDateFormat;

@JsxClass
public class File
extends Blob {
    private static final String LAST_MODIFIED_DATE_FORMAT = "EEE MMM dd yyyy HH:mm:ss 'GMT'Z (zzzz)";

    public File() {
    }

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public File(NativeArray fileBits, String fileName, ScriptableObject properties) {
        if (fileBits == null || Undefined.isUndefined(fileBits) || fileName == null || Undefined.isUndefined(fileName)) {
            throw ScriptRuntime.typeError("Failed to construct 'File': 2 arguments required.");
        }
        this.setBackend(Blob.InMemoryBackend.create(fileBits, fileName, File.extractFileTypeOrDefault(properties), File.extractLastModifiedOrDefault(properties)));
    }

    File(String pathname) {
        this.setBackend(new FileBackend(pathname));
    }

    @JsxGetter
    public String getName() {
        return this.getBackend().getName();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.IE})
    public String getLastModifiedDate() {
        Date date = new Date(this.getLastModified());
        BrowserVersion browser = this.getBrowserVersion();
        Locale locale = new Locale(browser.getSystemLanguage());
        TimeZone timezone = browser.getSystemTimezone();
        FastDateFormat format = FastDateFormat.getInstance(LAST_MODIFIED_DATE_FORMAT, timezone, locale);
        return format.format(date);
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public long getLastModified() {
        return this.getBackend().getLastModified();
    }

    @JsxGetter(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF78})
    public String getWebkitRelativePath() {
        return "";
    }

    @JsxFunction
    public void slice() {
    }

    @JsxFunction(value={SupportedBrowser.IE})
    public void msClose() {
    }

    public java.io.File getFile() {
        return this.getBackend().getFile();
    }

    private static class FileBackend
    extends Blob.Backend {
        private java.io.File file_;

        FileBackend(String pathname) {
            this.file_ = new java.io.File(pathname);
        }

        @Override
        public String getName() {
            return this.file_.getName();
        }

        @Override
        public long getLastModified() {
            return this.file_.lastModified();
        }

        @Override
        public long getSize() {
            return this.file_.length();
        }

        @Override
        public String getType(BrowserVersion browserVersion) {
            return browserVersion.getUploadMimeType(this.file_);
        }

        @Override
        public String getText() throws IOException {
            return FileUtils.readFileToString((java.io.File)this.file_, (Charset)StandardCharsets.UTF_8);
        }

        @Override
        public java.io.File getFile() {
            return this.file_;
        }

        @Override
        byte[] getBytes(int start, int end) {
            byte[] result = new byte[end - start];
            try {
                System.arraycopy(FileUtils.readFileToByteArray((java.io.File)this.file_), start, result, 0, result.length);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
    }
}

