/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.websocket;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebClientOptions;
import com.gargoylesoftware.htmlunit.websocket.WebSocketAdapter;
import com.gargoylesoftware.htmlunit.websocket.WebSocketCookieStore;
import java.io.IOException;
import java.net.CookieStore;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.concurrent.Future;
import net.sourceforge.htmlunit.corejs.javascript.typedarrays.NativeArrayBuffer;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketPolicy;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public abstract class JettyWebSocketAdapter
implements WebSocketAdapter {
    private Object clientLock_ = new Object();
    private WebSocketClient client_;
    private volatile Session incomingSession_;
    private Session outgoingSession_;

    public JettyWebSocketAdapter(WebClient webClient) {
        WebClientOptions options = webClient.getOptions();
        this.client_ = webClient.getOptions().isUseInsecureSSL() ? new WebSocketClient(new SslContextFactory(true), null, null) : new WebSocketClient();
        this.client_.setExecutor(webClient.getExecutor());
        this.client_.getHttpClient().setCookieStore((CookieStore)new WebSocketCookieStore(webClient));
        WebSocketPolicy policy = this.client_.getPolicy();
        int size = options.getWebSocketMaxBinaryMessageSize();
        if (size > 0) {
            policy.setMaxBinaryMessageSize(size);
        }
        if ((size = options.getWebSocketMaxBinaryMessageBufferSize()) > 0) {
            policy.setMaxBinaryMessageBufferSize(size);
        }
        if ((size = options.getWebSocketMaxTextMessageSize()) > 0) {
            policy.setMaxTextMessageSize(size);
        }
        if ((size = options.getWebSocketMaxTextMessageBufferSize()) > 0) {
            policy.setMaxTextMessageBufferSize(size);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start() throws Exception {
        Object object = this.clientLock_;
        synchronized (object) {
            this.client_.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(URI url) throws Exception {
        Object object = this.clientLock_;
        synchronized (object) {
            final Future connectFuture = this.client_.connect((Object)new JettyWebSocketAdapterImpl(), url);
            this.client_.getExecutor().execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        JettyWebSocketAdapter.this.onWebSocketConnecting();
                        JettyWebSocketAdapter.this.incomingSession_ = (Session)connectFuture.get();
                    }
                    catch (Exception e) {
                        JettyWebSocketAdapter.this.onWebSocketConnectError(e);
                    }
                }
            });
        }
    }

    @Override
    public void send(Object content) throws IOException {
        if (content instanceof String) {
            this.outgoingSession_.getRemote().sendString((String)content);
        } else if (content instanceof NativeArrayBuffer) {
            byte[] bytes = ((NativeArrayBuffer)content).getBuffer();
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            this.outgoingSession_.getRemote().sendBytes(buffer);
        } else {
            throw new IllegalStateException("Not Yet Implemented: WebSocket.send() was used to send non-string value");
        }
    }

    @Override
    public void closeIncommingSession() throws Exception {
        if (this.incomingSession_ != null) {
            this.incomingSession_.close();
        }
    }

    @Override
    public void closeOutgoingSession() throws Exception {
        if (this.outgoingSession_ != null) {
            this.outgoingSession_.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closeClient() throws Exception {
        Object object = this.clientLock_;
        synchronized (object) {
            if (this.client_ != null) {
                this.client_.stop();
                this.client_.destroy();
                this.client_ = null;
            }
        }
    }

    private class JettyWebSocketAdapterImpl
    extends org.eclipse.jetty.websocket.api.WebSocketAdapter {
        JettyWebSocketAdapterImpl() {
        }

        public void onWebSocketConnect(Session session) {
            super.onWebSocketConnect(session);
            JettyWebSocketAdapter.this.outgoingSession_ = session;
            JettyWebSocketAdapter.this.onWebSocketConnect();
        }

        public void onWebSocketClose(int statusCode, String reason) {
            super.onWebSocketClose(statusCode, reason);
            JettyWebSocketAdapter.this.outgoingSession_ = null;
            JettyWebSocketAdapter.this.onWebSocketClose(statusCode, reason);
        }

        public void onWebSocketText(String message) {
            super.onWebSocketText(message);
            JettyWebSocketAdapter.this.onWebSocketText(message);
        }

        public void onWebSocketBinary(byte[] data, int offset, int length) {
            super.onWebSocketBinary(data, offset, length);
            JettyWebSocketAdapter.this.onWebSocketBinary(data, offset, length);
        }

        public void onWebSocketError(Throwable cause) {
            super.onWebSocketError(cause);
            JettyWebSocketAdapter.this.outgoingSession_ = null;
            JettyWebSocketAdapter.this.onWebSocketError(cause);
        }
    }
}

