/*
 * Decompiled with CFR 0.152.
 */
package hidden.jth.org.apache.http.protocol;

import hidden.jth.org.apache.http.HttpEntityEnclosingRequest;
import hidden.jth.org.apache.http.HttpException;
import hidden.jth.org.apache.http.HttpRequest;
import hidden.jth.org.apache.http.HttpRequestInterceptor;
import hidden.jth.org.apache.http.annotation.Contract;
import hidden.jth.org.apache.http.annotation.ThreadingBehavior;
import hidden.jth.org.apache.http.protocol.HttpContext;
import hidden.jth.org.apache.http.protocol.HttpDateGenerator;
import hidden.jth.org.apache.http.util.Args;
import java.io.IOException;

@Contract(threading=ThreadingBehavior.SAFE)
public class RequestDate
implements HttpRequestInterceptor {
    private static final HttpDateGenerator DATE_GENERATOR = new HttpDateGenerator();

    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        if (request instanceof HttpEntityEnclosingRequest && !request.containsHeader("Date")) {
            String httpdate = DATE_GENERATOR.getCurrentDate();
            request.setHeader("Date", httpdate);
        }
    }
}

