/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.scm.NullSCM;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.io.FileUtils;

public class ExtractResourceSCM
extends NullSCM {
    private final URL zip;
    private String parentFolder;

    public ExtractResourceSCM(URL zip) {
        if (zip == null) {
            throw new IllegalArgumentException();
        }
        this.zip = zip;
    }

    public ExtractResourceSCM(URL zip, String parentFolder) {
        if (zip == null) {
            throw new IllegalArgumentException();
        }
        this.zip = zip;
        this.parentFolder = parentFolder;
    }

    public boolean checkout(AbstractBuild<?, ?> build, Launcher launcher, FilePath workspace, BuildListener listener, @NonNull File changeLogFile) throws IOException, InterruptedException {
        if (workspace.exists()) {
            listener.getLogger().println("Deleting existing workspace " + workspace.getRemote());
            workspace.deleteRecursive();
        }
        listener.getLogger().println("Staging " + this.zip);
        workspace.unzipFrom(this.zip.openStream());
        if (this.parentFolder != null) {
            FileUtils.copyDirectory((File)new File(workspace.getRemote() + "/" + this.parentFolder), (File)new File(workspace.getRemote()));
        }
        return true;
    }
}

