/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import hudson.security.SidACL;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.acegisecurity.acls.sid.PrincipalSid;
import org.acegisecurity.acls.sid.Sid;
import org.acegisecurity.context.SecurityContext;
import org.acegisecurity.context.SecurityContextHolder;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.jvnet.hudson.test.JenkinsRule;

public class CLICommandInvoker {
    private static final String username = "user";
    private final JenkinsRule rule;
    private final CLICommand command;
    @Deprecated
    private SecurityRealm originalSecurityRealm = null;
    @Deprecated
    private AuthorizationStrategy originalAuthorizationStrategy = null;
    @Deprecated
    private SecurityContext originalSecurityContext = null;
    private InputStream stdin;
    private List<String> args = Collections.emptyList();
    @Deprecated
    private List<Permission> permissions = Collections.emptyList();
    private Locale locale = Locale.ENGLISH;

    public CLICommandInvoker(JenkinsRule rule, CLICommand command) {
        if (command.getClass().getAnnotation(Extension.class) == null) {
            throw new AssertionError((Object)String.format("Command %s is missing @Extension annotation.", command.getClass()));
        }
        this.rule = rule;
        this.command = command;
    }

    public CLICommandInvoker(JenkinsRule rule, String command) {
        this.rule = rule;
        this.command = CLICommand.clone((String)command);
        if (this.command == null) {
            throw new AssertionError((Object)("No such command: " + command));
        }
    }

    @Deprecated
    public CLICommandInvoker authorizedTo(Permission ... permissions) {
        this.permissions = Arrays.asList(permissions);
        return this;
    }

    public CLICommandInvoker asUser(String user) {
        this.command.setTransportAuth(User.get((String)user).impersonate());
        return this;
    }

    public CLICommandInvoker withStdin(InputStream stdin) {
        if (stdin == null) {
            throw new NullPointerException("No stdin provided");
        }
        this.stdin = stdin;
        return this;
    }

    public CLICommandInvoker withArgs(String ... args) {
        this.args = Arrays.asList(args);
        return this;
    }

    public Result invokeWithArgs(String ... args) {
        return this.withArgs(args).invoke();
    }

    public Result invoke() {
        this.setAuth();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        int returnCode = this.command.main(this.args, this.locale, this.stdin, new PrintStream(out), new PrintStream(err));
        this.restoreAuth();
        return new Result(returnCode, out, err);
    }

    private void setAuth() {
        if (this.permissions.isEmpty()) {
            return;
        }
        JenkinsRule.DummySecurityRealm realm = this.rule.createDummySecurityRealm();
        realm.addGroups(username, "group");
        this.originalSecurityRealm = this.rule.jenkins.getSecurityRealm();
        this.rule.jenkins.setSecurityRealm((SecurityRealm)realm);
        this.originalAuthorizationStrategy = this.rule.jenkins.getAuthorizationStrategy();
        this.rule.jenkins.setAuthorizationStrategy((AuthorizationStrategy)new GrantPermissions(username, this.permissions));
        this.command.setTransportAuth(this.user().impersonate());
        this.originalSecurityContext = ACL.impersonate((Authentication)Jenkins.ANONYMOUS);
    }

    private void restoreAuth() {
        if (this.originalSecurityRealm != null) {
            this.rule.jenkins.setSecurityRealm(this.originalSecurityRealm);
            this.originalSecurityRealm = null;
        }
        if (this.originalAuthorizationStrategy != null) {
            this.rule.jenkins.setAuthorizationStrategy(this.originalAuthorizationStrategy);
            this.originalAuthorizationStrategy = null;
        }
        if (this.originalSecurityContext != null) {
            SecurityContextHolder.setContext((SecurityContext)this.originalSecurityContext);
            this.originalSecurityContext = null;
        }
    }

    @Deprecated
    public User user() {
        return User.get((String)username);
    }

    public static abstract class Matcher
    extends TypeSafeMatcher<Result> {
        private final String description;

        private Matcher(String description) {
            this.description = description;
        }

        protected void describeMismatchSafely(Result result, Description description) {
            description.appendText(result.toString());
        }

        public void describeTo(Description description) {
            description.appendText(this.description);
        }

        public static Matcher hasNoStandardOutput() {
            return new Matcher("No standard output"){

                protected boolean matchesSafely(Result result) {
                    return "".equals(result.stdout());
                }
            };
        }

        public static Matcher hasNoErrorOutput() {
            return new Matcher("No error output"){

                protected boolean matchesSafely(Result result) {
                    return "".equals(result.stderr());
                }
            };
        }

        public static Matcher succeeded() {
            return new Matcher("Exited with 0 return code"){

                protected boolean matchesSafely(Result result) {
                    return result.result == 0;
                }
            };
        }

        public static Matcher succeededSilently() {
            return new Matcher("Succeeded silently"){

                protected boolean matchesSafely(Result result) {
                    return result.result == 0 && "".equals(result.stderr()) && "".equals(result.stdout());
                }
            };
        }

        public static Matcher failedWith(final long expectedCode) {
            return new Matcher("Exited with " + expectedCode + " return code"){

                protected boolean matchesSafely(Result result) {
                    return (long)result.result == expectedCode;
                }
            };
        }
    }

    public static class Result {
        private final int result;
        private final ByteArrayOutputStream out;
        private final ByteArrayOutputStream err;

        private Result(int result, ByteArrayOutputStream out, ByteArrayOutputStream err) {
            this.result = result;
            this.out = out;
            this.err = err;
        }

        public int returnCode() {
            return this.result;
        }

        public String stdout() {
            return this.out.toString();
        }

        public String stderr() {
            return this.err.toString();
        }

        public String toString() {
            String stderr;
            StringBuilder builder = new StringBuilder("CLI command exited with ").append(this.result);
            String stdout = this.stdout();
            if (!"".equals(stdout)) {
                builder.append("\nSTDOUT:\n").append(stdout);
            }
            if (!"".equals(stderr = this.stderr())) {
                builder.append("\nSTDERR:\n").append(stderr);
            }
            return builder.toString();
        }
    }

    private static class GrantPermissions
    extends AuthorizationStrategy {
        final String username;
        final List<Permission> permissions;

        GrantPermissions(String username, List<Permission> permissions) {
            this.username = username;
            this.permissions = permissions;
            for (Permission p : permissions) {
                p.setEnabled(true);
            }
        }

        public ACL getRootACL() {
            return new SidACL(){

                protected Boolean hasPermission(Sid u, Permission permission) {
                    if (u instanceof PrincipalSid && ((PrincipalSid)u).getPrincipal().equals(username)) {
                        Permission p = permission;
                        while (p != null) {
                            if (permissions.contains(p)) {
                                return true;
                            }
                            p = p.impliedBy;
                        }
                    }
                    return false;
                }
            };
        }

        public Collection<String> getGroups() {
            return Collections.emptySet();
        }
    }
}

