/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.util.RingBufferLogHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.junit.rules.ExternalResource;
import org.jvnet.hudson.test.SupportLogFormatter;

public class LoggerRule
extends ExternalResource {
    private final Handler consoleHandler = new ConsoleHandler();
    private final Map<Logger, Level> loggers = new HashMap<Logger, Level>();
    private RingBufferLogHandler ringHandler;
    private List<String> messages;

    public LoggerRule() {
        this.consoleHandler.setFormatter(new SupportLogFormatter());
        this.consoleHandler.setLevel(Level.ALL);
    }

    public LoggerRule capture(int maximum) {
        this.messages = new ArrayList<String>();
        this.ringHandler = new RingBufferLogHandler(maximum){
            final Formatter f;
            {
                this.f = new SimpleFormatter();
            }

            public synchronized void publish(LogRecord record) {
                super.publish(record);
                String message = this.f.formatMessage(record);
                Throwable x = record.getThrown();
                LoggerRule.this.messages.add(message == null && x != null ? x.toString() : message);
            }
        };
        this.ringHandler.setLevel(Level.ALL);
        for (Logger logger : this.loggers.keySet()) {
            logger.addHandler((Handler)this.ringHandler);
        }
        return this;
    }

    public LoggerRule record(Logger logger, Level level) {
        this.loggers.put(logger, logger.getLevel());
        logger.setLevel(level);
        logger.addHandler(this.consoleHandler);
        if (this.ringHandler != null) {
            logger.addHandler((Handler)this.ringHandler);
        }
        return this;
    }

    public LoggerRule record(String name, Level level) {
        return this.record(Logger.getLogger(name), level);
    }

    public LoggerRule record(Class<?> clazz, Level level) {
        return this.record(clazz.getName(), level);
    }

    public List<LogRecord> getRecords() {
        return this.ringHandler.getView();
    }

    public List<String> getMessages() {
        return this.messages;
    }

    protected void after() {
        for (Map.Entry<Logger, Level> entry : this.loggers.entrySet()) {
            Logger logger = entry.getKey();
            logger.setLevel(entry.getValue());
            logger.removeHandler(this.consoleHandler);
            if (this.ringHandler == null) continue;
            logger.removeHandler((Handler)this.ringHandler);
        }
        this.loggers.clear();
        if (this.ringHandler != null) {
            this.ringHandler.clear();
            this.messages.clear();
        }
    }
}

