/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import groovy.lang.Closure;
import java.io.File;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import org.junit.rules.MethodRule;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.Description;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.jvnet.hudson.test.HudsonHomeLoader;
import org.jvnet.hudson.test.JenkinsRule;

public class RestartableJenkinsRule
implements MethodRule {
    public JenkinsRule j;
    private Description description;
    private final List<Statement> steps = new ArrayList<Statement>();
    private TemporaryFolder tmp = new TemporaryFolder();
    private Object target;
    public File home;

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        this.description = Description.createTestDescription(method.getMethod().getDeclaringClass(), (String)method.getName(), (Annotation[])method.getAnnotations());
        this.target = target;
        return this.tmp.apply(new Statement(){

            public void evaluate() throws Throwable {
                RestartableJenkinsRule.this.home = RestartableJenkinsRule.this.tmp.newFolder();
                base.evaluate();
                RestartableJenkinsRule.this.run();
            }
        }, this.description);
    }

    public void step(final Closure c) {
        this.addStep(new Statement(){

            public void evaluate() throws Throwable {
                c.call((Object)RestartableJenkinsRule.this.j);
            }
        });
    }

    public void then(final Step s) {
        this.addStep(new Statement(){

            public void evaluate() throws Throwable {
                s.run(RestartableJenkinsRule.this.j);
            }
        });
    }

    public void addStep(final Statement step) {
        this.steps.add(new Statement(){

            public void evaluate() throws Throwable {
                RestartableJenkinsRule.this.j.jenkins.getInjector().injectMembers((Object)step);
                RestartableJenkinsRule.this.j.jenkins.getInjector().injectMembers(RestartableJenkinsRule.this.target);
                step.evaluate();
            }
        });
    }

    private void run() throws Throwable {
        HudsonHomeLoader loader = new HudsonHomeLoader(){

            @Override
            public File allocate() throws Exception {
                return RestartableJenkinsRule.this.home;
            }
        };
        for (Statement step : this.steps) {
            this.j = this.createJenkinsRule(this.description).with(loader);
            this.j.apply(step, this.description).evaluate();
        }
    }

    protected JenkinsRule createJenkinsRule(Description description) {
        return new JenkinsRule();
    }

    public static interface Step {
        public void run(JenkinsRule var1) throws Throwable;
    }
}

