/*
 * Decompiled with CFR 0.152.
 */
package jenkins.benchmark.jmh;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.Hudson;
import hudson.model.RootAction;
import hudson.security.ACL;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import jenkins.model.Jenkins;
import jenkins.model.JenkinsLocationConfiguration;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.jvnet.hudson.test.JavaNetReverseProxy;
import org.jvnet.hudson.test.JenkinsRule;
import org.jvnet.hudson.test.TemporaryDirectoryAllocator;
import org.jvnet.hudson.test.TestPluginManager;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.springframework.security.core.Authentication;

@State(value=Scope.Benchmark)
public abstract class JmhBenchmarkState
implements RootAction {
    private static final Logger LOGGER = Logger.getLogger(JmhBenchmarkState.class.getName());
    private static final String contextPath = "/jenkins";
    private final TemporaryDirectoryAllocator temporaryDirectoryAllocator = new TemporaryDirectoryAllocator();
    private final AtomicInteger localPort = new AtomicInteger();
    private Jenkins jenkins = null;
    private Server server = null;

    @Setup(value=Level.Trial)
    public final void setupJenkins() throws Exception {
        System.setProperty("jenkins.install.state", "TEST");
        this.launchInstance();
        ACL.impersonate2((Authentication)ACL.SYSTEM2);
        this.setup();
    }

    @TearDown(value=Level.Trial)
    public final void terminateJenkins() {
        try {
            this.tearDown();
        }
        catch (Exception e) {
            LOGGER.log(java.util.logging.Level.SEVERE, "Exception occurred during tearDown of Jenkins instance", e);
        }
        finally {
            JenkinsRule._stopJenkins(this.server, null, this.jenkins);
            try {
                JavaNetReverseProxy.getInstance().stop();
            }
            catch (Exception e) {
                LOGGER.log(java.util.logging.Level.WARNING, "Unable to stop JavaNetReverseProxy server", e);
            }
            try {
                this.temporaryDirectoryAllocator.dispose();
            }
            catch (IOException | InterruptedException e) {
                LOGGER.log(java.util.logging.Level.WARNING, "Unable to dispose temporary Jenkins directorythat was started for benchmark", e);
            }
        }
    }

    private void launchInstance() throws Exception {
        this.server = JenkinsRule._createWebServer(contextPath, this.localPort::set, this.getClass().getClassLoader(), this.localPort.get(), JenkinsRule::_configureUserRealm);
        ContextHandler.Context webServer = ((ContextHandler)this.server.getChildHandlerByClass(ContextHandler.class)).getServletContext();
        this.jenkins = new Hudson(this.temporaryDirectoryAllocator.allocate(), (ServletContext)webServer, TestPluginManager.INSTANCE);
        JenkinsRule._configureJenkinsForTest(this.jenkins);
        JenkinsRule._configureUpdateCenter(this.jenkins);
        this.jenkins.getActions().add(this);
        String url = Objects.requireNonNull(this.getJenkinsURL()).toString();
        Objects.requireNonNull(JenkinsLocationConfiguration.get()).setUrl(url);
        LOGGER.log(java.util.logging.Level.INFO, "Running on {0}", url);
    }

    private URL getJenkinsURL() throws MalformedURLException {
        return new URL("http://localhost:" + this.localPort.get() + "/jenkins/");
    }

    public Jenkins getJenkins() {
        return this.jenkins;
    }

    public void setup() throws Exception {
    }

    public void tearDown() {
    }

    @CheckForNull
    public String getIconFileName() {
        return null;
    }

    @CheckForNull
    public String getDisplayName() {
        return null;
    }

    @CheckForNull
    public String getUrlName() {
        return "self";
    }
}

