/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.Main;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Channel;
import hudson.remoting.VirtualChannel;
import hudson.slaves.ComputerListener;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.jvnet.hudson.test.EndOfTestListener;

@Extension
public class ChannelShutdownListener
extends ComputerListener
implements EndOfTestListener {
    private List<WeakReference<Channel>> channels = new ArrayList<WeakReference<Channel>>();

    public ChannelShutdownListener() {
        if (!Main.isUnitTest) {
            Logger.getLogger(ChannelShutdownListener.class.getName()).severe(() -> "JENKINS-58771: Jenkins test harness code being loaded in what seems to be a production system, perhaps causing critical memory leaks: " + ChannelShutdownListener.class.getProtectionDomain().getCodeSource().getLocation());
        }
    }

    public synchronized void onOnline(Computer c, TaskListener listener) throws IOException, InterruptedException {
        VirtualChannel ch = c.getChannel();
        if (ch instanceof Channel) {
            this.channels.add(new WeakReference<Channel>((Channel)ch));
        }
    }

    @Override
    public synchronized void onTearDown() throws Exception {
        Channel c;
        for (WeakReference<Channel> cr : this.channels) {
            c = (Channel)cr.get();
            if (c == null) continue;
            c.close();
        }
        for (WeakReference<Channel> cr : this.channels) {
            c = (Channel)cr.get();
            if (c == null) continue;
            c.join();
        }
        this.channels.clear();
    }
}

