/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.rules.ExternalResource;

public final class FlagRule<T>
extends ExternalResource {
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private final boolean replace;
    private final T replacement;
    private T orig;

    public FlagRule(Supplier<T> getter, Consumer<T> setter) {
        this.getter = getter;
        this.setter = setter;
        this.replace = false;
        this.replacement = null;
    }

    public FlagRule(Supplier<T> getter, Consumer<T> setter, T replacement) {
        this.getter = getter;
        this.setter = setter;
        this.replace = true;
        this.replacement = replacement;
    }

    protected void before() throws Throwable {
        this.orig = this.getter.get();
        if (this.replace) {
            this.setter.accept(this.replacement);
        }
    }

    protected void after() {
        this.setter.accept(this.orig);
    }

    public static FlagRule<String> systemProperty(String key) {
        return new FlagRule<String>(() -> System.getProperty(key), value -> FlagRule.setProperty(key, value));
    }

    public static FlagRule<String> systemProperty(String key, String replacement) {
        return new FlagRule<String>(() -> System.getProperty(key), value -> FlagRule.setProperty(key, value), replacement);
    }

    private static String setProperty(String key, String value) {
        if (value != null) {
            return System.setProperty(key, value);
        }
        return (String)System.getProperties().remove(key);
    }
}

