/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class TemporaryDirectoryAllocator {
    private static final Logger LOGGER = Logger.getLogger(TemporaryDirectoryAllocator.class.getName());
    private final Set<File> tmpDirectories = new HashSet<File>();
    private final File base;
    private final boolean withoutSpace = Boolean.getBoolean("jenkins.test.noSpaceInTmpDirs");

    @Deprecated
    public TemporaryDirectoryAllocator(File base) {
        this.base = base;
    }

    public TemporaryDirectoryAllocator() {
        this.base = new File(System.getProperty("java.io.tmpdir"));
        this.base.mkdirs();
    }

    public synchronized File allocate() throws IOException {
        try {
            File f = Files.createTempDirectory(this.base.toPath(), this.withoutSpace ? "jkh" : "j h", new FileAttribute[0]).toFile();
            this.tmpDirectories.add(f);
            return f;
        }
        catch (IOException e) {
            throw new IOException("Failed to create a temporary directory in " + this.base, e);
        }
    }

    public synchronized void dispose() throws IOException, InterruptedException {
        for (File dir : this.tmpDirectories) {
            LOGGER.info(() -> "deleting " + dir);
            this.delete(dir.toPath());
        }
        this.tmpDirectories.clear();
    }

    public synchronized void disposeAsync() {
        final HashSet<File> tbr = new HashSet<File>(this.tmpDirectories);
        this.tmpDirectories.clear();
        new Thread("Disposing " + this.base){

            @Override
            public void run() {
                for (File dir : tbr) {
                    LOGGER.info(() -> "deleting " + dir);
                    try {
                        TemporaryDirectoryAllocator.this.delete(dir.toPath());
                    }
                    catch (IOException e) {
                        LOGGER.log(Level.WARNING, null, e);
                    }
                }
            }
        }.start();
    }

    private void delete(Path p) throws IOException {
        LOGGER.fine(() -> "deleting " + p);
        if (Files.isDirectory(p, LinkOption.NOFOLLOW_LINKS)) {
            try (DirectoryStream<Path> children = Files.newDirectoryStream(p);){
                for (Path child : children) {
                    this.delete(child);
                }
            }
        }
        try {
            if (this.isWindows()) {
                boolean ok = p.toFile().setWritable(true);
                LOGGER.fine(() -> "allow write to " + p + ", result: " + ok);
            }
            Files.deleteIfExists(p);
        }
        catch (DirectoryNotEmptyException x) {
            Stream<Path> children = Files.list(p);
            try {
                throw new IOException(children.map(Path::toString).collect(Collectors.joining(" ")), x);
            }
            catch (Throwable throwable) {
                if (children != null) {
                    try {
                        children.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
        }
    }

    private boolean isWindows() {
        return File.pathSeparatorChar == ';';
    }
}

