/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import java.io.IOException;
import java.nio.charset.Charset;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import org.jenkinsci.remoting.engine.Jnlp3Util;

class HandshakeCiphers {
    private final SecretKey secretKey;
    private final IvParameterSpec spec;
    private final Cipher encryptCipher;
    private final Cipher decryptCipher;
    private static final String CIPHER_TRANSFORMATION = "AES/CTR/PKCS5Padding";
    private static final String FACTORY_ALGORITHM = "PBKDF2WithHmacSHA1";
    private static final String SPEC_ALGORITHM = "AES";
    private static final int INTEGRATION_COUNT = 65536;
    private static final int KEY_LENGTH = 128;

    HandshakeCiphers(SecretKey secretKey, IvParameterSpec spec, Cipher encryptCipher, Cipher decryptCipher) {
        this.secretKey = secretKey;
        this.spec = spec;
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
    }

    public String encrypt(String raw) throws IOException {
        try {
            String encrypted = new String(this.encryptCipher.doFinal(raw.getBytes(Charset.forName("UTF-8"))), Charset.forName("ISO-8859-1"));
            this.encryptCipher.init(1, (Key)this.secretKey, this.spec);
            return encrypted;
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to encrypt message", e);
        }
    }

    public String decrypt(String encrypted) throws IOException {
        try {
            String raw = new String(this.decryptCipher.doFinal(encrypted.getBytes(Charset.forName("ISO-8859-1"))), Charset.forName("UTF-8"));
            this.decryptCipher.init(2, (Key)this.secretKey, this.spec);
            return raw;
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to decrypt message", e);
        }
    }

    public static HandshakeCiphers create(String slaveName, String slaveSecret) throws IOException {
        try {
            byte[] specKey = Jnlp3Util.generate128BitKey(slaveName + slaveSecret);
            IvParameterSpec spec = new IvParameterSpec(specKey);
            SecretKey secretKey = HandshakeCiphers.generateSecretKey(slaveName, slaveSecret);
            Cipher encryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            encryptCipher.init(1, (Key)secretKey, spec);
            Cipher decryptCipher = Cipher.getInstance(CIPHER_TRANSFORMATION);
            decryptCipher.init(2, (Key)secretKey, spec);
            return new HandshakeCiphers(secretKey, spec, encryptCipher, decryptCipher);
        }
        catch (GeneralSecurityException e) {
            throw new IOException("Failed to create handshake ciphers", e);
        }
    }

    private static SecretKey generateSecretKey(String slaveName, String slaveSecret) throws GeneralSecurityException {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(FACTORY_ALGORITHM);
        PBEKeySpec spec = new PBEKeySpec(slaveSecret.toCharArray(), slaveName.getBytes(Charset.forName("UTF-8")), 65536, 128);
        SecretKey tmpSecret = factory.generateSecret(spec);
        return new SecretKeySpec(tmpSecret.getEncoded(), SPEC_ALGORITHM);
    }
}

