/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.remoting.engine;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.remoting.Launcher;
import hudson.remoting.NoProxyEvaluator;
import hudson.remoting.Util;
import java.io.IOException;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.NoRouteToHostException;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.jenkinsci.remoting.engine.HostPort;
import org.jenkinsci.remoting.engine.JnlpAgentEndpoint;
import org.jenkinsci.remoting.engine.JnlpEndpointResolver;
import org.jenkinsci.remoting.util.DurationFormatter;
import org.jenkinsci.remoting.util.ThrowableUtils;
import org.jenkinsci.remoting.util.VersionNumber;
import org.jenkinsci.remoting.util.https.NoCheckHostnameVerifier;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class JnlpAgentEndpointResolver
extends JnlpEndpointResolver {
    private static final Logger LOGGER = Logger.getLogger(JnlpAgentEndpointResolver.class.getName());
    @NonNull
    private final List<String> jenkinsUrls;
    private final String agentName;
    private String credentials;
    private String proxyCredentials;
    private String tunnel;
    private SSLSocketFactory sslSocketFactory;
    private boolean disableHttpsCertValidation;
    private HostnameVerifier hostnameVerifier;
    private Duration noReconnectAfter;
    private static String PROTOCOL_NAMES_TO_TRY = System.getProperty(JnlpAgentEndpointResolver.class.getName() + ".protocolNamesToTry");

    public JnlpAgentEndpointResolver(@NonNull List<String> jenkinsUrls, String agentName, String credentials, String proxyCredentials, String tunnel, SSLSocketFactory sslSocketFactory, boolean disableHttpsCertValidation, Duration noReconnectAfter) {
        this.jenkinsUrls = new ArrayList<String>(jenkinsUrls);
        this.agentName = agentName;
        this.credentials = credentials;
        this.proxyCredentials = proxyCredentials;
        this.tunnel = tunnel;
        this.sslSocketFactory = sslSocketFactory;
        this.setDisableHttpsCertValidation(disableHttpsCertValidation);
        this.noReconnectAfter = noReconnectAfter;
    }

    public SSLSocketFactory getSslSocketFactory() {
        return this.sslSocketFactory;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public String getCredentials() {
        return this.credentials;
    }

    public void setCredentials(String credentials) {
        this.credentials = credentials;
    }

    public void setCredentials(String user, String pass) {
        this.credentials = user + ":" + pass;
    }

    public String getProxyCredentials() {
        return this.proxyCredentials;
    }

    public void setProxyCredentials(String proxyCredentials) {
        this.proxyCredentials = proxyCredentials;
    }

    public void setProxyCredentials(String user, String pass) {
        this.proxyCredentials = user + ":" + pass;
    }

    @CheckForNull
    public String getTunnel() {
        return this.tunnel;
    }

    public void setTunnel(@CheckForNull String tunnel) {
        this.tunnel = tunnel;
    }

    public boolean isDisableHttpsCertValidation() {
        return this.disableHttpsCertValidation;
    }

    public void setDisableHttpsCertValidation(boolean disableHttpsCertValidation) {
        this.disableHttpsCertValidation = disableHttpsCertValidation;
        this.hostnameVerifier = disableHttpsCertValidation ? new NoCheckHostnameVerifier() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @CheckForNull
    public JnlpAgentEndpoint resolve() throws IOException {
        IOException firstError = null;
        Iterator<String> iterator = this.jenkinsUrls.iterator();
        while (true) {
            int port;
            RSAPublicKey identity;
            String host;
            String portStr;
            Set<String> agentProtocolNames;
            HttpURLConnection con;
            URL selectedJenkinsURL;
            String jenkinsUrl;
            block35: {
                block34: {
                    URL salURL;
                    block33: {
                        block32: {
                            VersionNumber minimumSupportedVersion;
                            VersionNumber currentVersion;
                            if (!iterator.hasNext()) {
                                if (firstError == null) return null;
                                throw firstError;
                            }
                            jenkinsUrl = iterator.next();
                            if (jenkinsUrl == null) continue;
                            try {
                                selectedJenkinsURL = new URL(jenkinsUrl);
                                salURL = this.toAgentListenerURL(jenkinsUrl);
                            }
                            catch (MalformedURLException ex) {
                                LOGGER.log(Level.WARNING, String.format("Cannot parse agent endpoint URL %s. Skipping it", jenkinsUrl), ex);
                                continue;
                            }
                            con = (HttpURLConnection)JnlpAgentEndpointResolver.openURLConnection(salURL, this.agentName, this.credentials, this.proxyCredentials, this.sslSocketFactory, this.hostnameVerifier);
                            try {
                                con.setConnectTimeout(30000);
                                con.setReadTimeout(60000);
                                con.connect();
                            }
                            catch (IOException x) {
                                firstError = (IOException)ThrowableUtils.chain(firstError, new IOException("Failed to connect to " + salURL + ": " + x.getMessage(), x));
                                con.disconnect();
                            }
                            if (con.getResponseCode() != 200) {
                                firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(salURL + " is invalid: " + con.getResponseCode() + " " + con.getResponseMessage()));
                                con.disconnect();
                            }
                            String minimumSupportedVersionHeader = con.getHeaderField("X-Remoting-Minimum-Version");
                            if (minimumSupportedVersionHeader == null || !(currentVersion = new VersionNumber(Launcher.VERSION)).isOlderThan(minimumSupportedVersion = new VersionNumber(minimumSupportedVersionHeader))) break block32;
                            firstError = (IOException)ThrowableUtils.chain(firstError, new IOException("Agent version " + minimumSupportedVersion + " or newer is required."));
                            con.disconnect();
                        }
                        agentProtocolNames = null;
                        portStr = Optional.ofNullable(con.getHeaderField("X-Jenkins-JNLP-Port")).orElse(con.getHeaderField("X-Hudson-JNLP-Port"));
                        host = Optional.ofNullable(con.getHeaderField("X-Jenkins-JNLP-Host")).orElse(salURL.getHost());
                        String protocols = con.getHeaderField("X-Jenkins-Agent-Protocols");
                        if (protocols != null) {
                            agentProtocolNames = Stream.of(protocols.split(",")).map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.toSet());
                            if (agentProtocolNames.isEmpty()) {
                                LOGGER.log(Level.WARNING, "Received the empty list of supported protocols from the server. All protocols are disabled on the controller side OR the 'X-Jenkins-Agent-Protocols' header is corrupted (JENKINS-41730). In the case of the header corruption as a workaround you can use the 'org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver.protocolNamesToTry' system property to define the supported protocols.");
                            } else {
                                LOGGER.log(Level.INFO, "Remoting server accepts the following protocols: {0}", agentProtocolNames);
                            }
                        }
                        if (PROTOCOL_NAMES_TO_TRY != null) {
                            LOGGER.log(Level.INFO, "Ignoring the list of supported remoting protocols provided by the server, because the 'org.jenkinsci.remoting.engine.JnlpAgentEndpointResolver.protocolNamesToTry' property is defined. Will try {0}", PROTOCOL_NAMES_TO_TRY);
                            agentProtocolNames = Stream.of(PROTOCOL_NAMES_TO_TRY.split(",")).map(String::trim).filter(Predicate.not(String::isEmpty)).collect(Collectors.toSet());
                        }
                        String idHeader = con.getHeaderField("X-Instance-Identity");
                        identity = this.getIdentity(idHeader);
                        if (identity != null) break block33;
                        firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(salURL + " appears to be publishing an invalid X-Instance-Identity."));
                        con.disconnect();
                    }
                    break block34;
                    catch (InvalidKeySpecException e) {
                        firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(salURL + " appears to be publishing an invalid X-Instance-Identity."));
                        con.disconnect();
                    }
                }
                if (portStr != null) break block35;
                firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(jenkinsUrl + " is not Jenkins"));
                con.disconnect();
            }
            try {
                port = Integer.parseInt(portStr);
            }
            catch (NumberFormatException e) {
                firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(jenkinsUrl + " is publishing an invalid port", e));
                con.disconnect();
            }
            try {
                if (port <= 0 || 65536 <= port) {
                    firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(jenkinsUrl + " is publishing an invalid port"));
                    continue;
                }
                if (this.tunnel == null) {
                    if (!this.isPortVisible(host, port)) {
                        firstError = (IOException)ThrowableUtils.chain(firstError, new IOException(jenkinsUrl + " provided port:" + port + " is not reachable on host " + host));
                        continue;
                    }
                    LOGGER.log(Level.FINE, "TCP Agent Listener Port availability check passed");
                } else {
                    LOGGER.log(Level.INFO, "Remoting TCP connection tunneling is enabled. Skipping the TCP Agent Listener Port availability check");
                }
                String winningJenkinsUrl = jenkinsUrl;
                this.jenkinsUrls.sort((o1, o2) -> {
                    if (winningJenkinsUrl.equals(o1)) {
                        return -1;
                    }
                    if (winningJenkinsUrl.equals(o2)) {
                        return 1;
                    }
                    return 0;
                });
                if (this.tunnel != null) {
                    HostPort hostPort = new HostPort(this.tunnel, host, port);
                    host = hostPort.getHost();
                    port = hostPort.getPort();
                }
                JnlpAgentEndpoint jnlpAgentEndpoint = new JnlpAgentEndpoint(host, port, identity, agentProtocolNames, selectedJenkinsURL, this.proxyCredentials);
                return jnlpAgentEndpoint;
            }
            finally {
                con.disconnect();
                continue;
            }
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @SuppressFBWarnings(value={"UNENCRYPTED_SOCKET"}, justification="This just verifies connection to the port. No data is transmitted.")
    private synchronized boolean isPortVisible(String hostname, int port) {
        boolean exitStatus;
        block21: {
            Authenticator orig;
            Socket s;
            block17: {
                block18: {
                    InetSocketAddress proxyToUse;
                    exitStatus = false;
                    s = null;
                    orig = null;
                    if (this.proxyCredentials != null) {
                        final int index = this.proxyCredentials.indexOf(58);
                        if (index < 0) {
                            throw new IllegalArgumentException("Invalid credential");
                        }
                        orig = Authenticator.getDefault();
                        Authenticator.setDefault(new Authenticator(){

                            @Override
                            protected PasswordAuthentication getPasswordAuthentication() {
                                if (this.getRequestorType().equals((Object)Authenticator.RequestorType.PROXY)) {
                                    return new PasswordAuthentication(JnlpAgentEndpointResolver.this.proxyCredentials.substring(0, index), JnlpAgentEndpointResolver.this.proxyCredentials.substring(index + 1).toCharArray());
                                }
                                return super.getPasswordAuthentication();
                            }
                        });
                    }
                    s = (proxyToUse = JnlpAgentEndpointResolver.getResolvedHttpProxyAddress(hostname, port)) == null ? new Socket() : new Socket(new Proxy(Proxy.Type.HTTP, proxyToUse));
                    s.setReuseAddress(true);
                    InetSocketAddress sa = new InetSocketAddress(hostname, port);
                    s.connect(sa, 5000);
                    if (s == null) break block17;
                    if (!s.isConnected()) break block18;
                    exitStatus = true;
                }
                try {
                    s.close();
                }
                catch (IOException e) {
                    LOGGER.warning(e.getMessage());
                }
            }
            if (orig != null) {
                Authenticator.setDefault(orig);
            }
            break block21;
            catch (IOException e) {
                block19: {
                    block20: {
                        try {
                            LOGGER.warning(e.getMessage());
                            if (s == null) break block19;
                            if (!s.isConnected()) break block20;
                            exitStatus = true;
                        }
                        catch (Throwable throwable) {
                            if (s != null) {
                                if (s.isConnected()) {
                                    exitStatus = true;
                                }
                                try {
                                    s.close();
                                }
                                catch (IOException e2) {
                                    LOGGER.warning(e2.getMessage());
                                }
                            }
                            if (orig != null) {
                                Authenticator.setDefault(orig);
                            }
                            throw throwable;
                        }
                    }
                    try {
                        s.close();
                    }
                    catch (IOException e3) {
                        LOGGER.warning(e3.getMessage());
                    }
                }
                if (orig != null) {
                    Authenticator.setDefault(orig);
                }
            }
        }
        return exitStatus;
    }

    @NonNull
    private URL toAgentListenerURL(@NonNull String jenkinsUrl) throws MalformedURLException {
        return new URL(jenkinsUrl + "tcpSlaveAgentListener/");
    }

    @Override
    public void waitForReady() throws InterruptedException {
        Thread t = Thread.currentThread();
        String oldName = t.getName();
        try {
            int retries = 0;
            Instant firstAttempt = Instant.now();
            while (true) {
                HttpURLConnection con;
                URL url;
                String firstUrl;
                block13: {
                    if (Util.shouldBailOut(firstAttempt, this.noReconnectAfter)) {
                        LOGGER.info("Bailing out after " + DurationFormatter.format(this.noReconnectAfter));
                        return;
                    }
                    Thread.sleep(10000L);
                    if (this.jenkinsUrls.isEmpty()) {
                        return;
                    }
                    firstUrl = this.jenkinsUrls.get(0);
                    url = this.toAgentListenerURL(firstUrl);
                    t.setName(oldName + ": trying " + url + " for " + ++retries + " times");
                    con = (HttpURLConnection)JnlpAgentEndpointResolver.openURLConnection(url, this.agentName, this.credentials, this.proxyCredentials, this.sslSocketFactory, this.hostnameVerifier);
                    con.setConnectTimeout(5000);
                    con.setReadTimeout(5000);
                    con.connect();
                    if (con.getResponseCode() != 200) break block13;
                    return;
                }
                try {
                    LOGGER.log(Level.INFO, "Controller isn''t ready to talk to us on {0}. Will try again: response code={1}", new Object[]{url, con.getResponseCode()});
                }
                catch (ConnectException | NoRouteToHostException | SocketTimeoutException e) {
                    LOGGER.log(Level.INFO, "Failed to connect to {0}. Will try again: {1} {2}", new String[]{firstUrl, e.getClass().getName(), e.getMessage()});
                }
                catch (IOException e) {
                    LOGGER.log(Level.INFO, e, () -> "Failed to connect to " + firstUrl + ". Will try again");
                }
            }
        }
        finally {
            t.setName(oldName);
        }
    }

    @CheckForNull
    static InetSocketAddress getResolvedHttpProxyAddress(@NonNull String host, int port) throws IOException {
        String httpProxy;
        URI uri;
        InetSocketAddress targetAddress = null;
        try {
            uri = new URI("http", null, host, port, null, null, null);
        }
        catch (URISyntaxException x) {
            throw new IOException(x);
        }
        Iterator<Proxy> proxies = ProxySelector.getDefault().select(uri).iterator();
        while (targetAddress == null && proxies.hasNext()) {
            String nonProxyHosts;
            Proxy proxy = proxies.next();
            if (proxy.type() == Proxy.Type.DIRECT && (nonProxyHosts = System.getProperty("http.nonProxyHosts")) != null && nonProxyHosts.length() != 0) {
                StringJoiner sj = new StringJoiner("|");
                nonProxyHosts = nonProxyHosts.toLowerCase(Locale.ENGLISH);
                for (String entry : nonProxyHosts.split("\\|")) {
                    if (entry.isEmpty()) continue;
                    if (entry.startsWith("*")) {
                        sj.add(".*" + Pattern.quote(entry.substring(1)));
                    } else if (entry.endsWith("*")) {
                        sj.add(Pattern.quote(entry.substring(0, entry.length() - 1)) + ".*");
                    } else {
                        sj.add(Pattern.quote(entry));
                    }
                    if (entry.split("\\*").length <= 2) continue;
                    LOGGER.log(Level.WARNING, "Using more than one wildcard is not supported in nonProxyHosts entries: {0}", entry);
                }
                Pattern nonProxyRegexps = Pattern.compile(sj.toString());
                if (!nonProxyRegexps.matcher(host.toLowerCase(Locale.ENGLISH)).matches()) break;
                return null;
            }
            if (proxy.type() != Proxy.Type.HTTP) continue;
            SocketAddress address = proxy.address();
            if (!(address instanceof InetSocketAddress)) {
                LOGGER.log(Level.WARNING, "Unsupported proxy address type {0}", address != null ? address.getClass() : "null");
                continue;
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)address;
            if (proxyAddress.isUnresolved()) {
                proxyAddress = new InetSocketAddress(proxyAddress.getHostName(), proxyAddress.getPort());
            }
            targetAddress = proxyAddress;
        }
        if (targetAddress == null && (httpProxy = System.getenv("http_proxy")) != null && NoProxyEvaluator.shouldProxy(host)) {
            try {
                URL url = new URL(httpProxy);
                targetAddress = new InetSocketAddress(url.getHost(), url.getPort());
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "Not using http_proxy environment variable which is invalid.", e);
            }
        }
        return targetAddress;
    }

    @Restricted(value={NoExternalUse.class})
    @SuppressFBWarnings(value={"URLCONNECTION_SSRF_FD"}, justification="Used by the agent for retrieving connection info from the server.")
    public static URLConnection openURLConnection(URL url, @CheckForNull String agentName, @CheckForNull String credentials, @CheckForNull String proxyCredentials, @CheckForNull SSLSocketFactory sslSocketFactory, @CheckForNull HostnameVerifier hostnameVerifier) throws IOException {
        String encoding;
        URLConnection con;
        String httpProxy = null;
        if (System.getProperty("http.proxyHost") == null) {
            httpProxy = System.getenv("http_proxy");
        }
        if (httpProxy != null && "http".equals(url.getProtocol()) && NoProxyEvaluator.shouldProxy(url.getHost())) {
            try {
                URL proxyUrl = new URL(httpProxy);
                InetSocketAddress addr = new InetSocketAddress(proxyUrl.getHost(), proxyUrl.getPort());
                Proxy proxy = new Proxy(Proxy.Type.HTTP, addr);
                con = url.openConnection(proxy);
            }
            catch (MalformedURLException e) {
                LOGGER.log(Level.WARNING, "Not using http_proxy environment variable which is invalid.", e);
                con = url.openConnection();
            }
        } else {
            con = url.openConnection();
        }
        if (agentName != null) {
            con.setRequestProperty("Node-Name", agentName);
        }
        if (credentials != null) {
            encoding = Base64.getEncoder().encodeToString(credentials.getBytes(StandardCharsets.UTF_8));
            con.setRequestProperty("Authorization", "Basic " + encoding);
        }
        if (proxyCredentials != null) {
            encoding = Base64.getEncoder().encodeToString(proxyCredentials.getBytes(StandardCharsets.UTF_8));
            con.setRequestProperty("Proxy-Authorization", "Basic " + encoding);
        }
        if (con instanceof HttpsURLConnection) {
            HttpsURLConnection httpsConnection = (HttpsURLConnection)con;
            if (sslSocketFactory != null) {
                httpsConnection.setSSLSocketFactory(sslSocketFactory);
            }
            if (hostnameVerifier != null) {
                httpsConnection.setHostnameVerifier(hostnameVerifier);
            }
        }
        return con;
    }
}

