/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jvnet.hudson.AbstractMemoryMonitorImpl;
import org.jvnet.hudson.MemoryMonitor;
import org.jvnet.hudson.MemoryUsage;

public class Aix
extends AbstractMemoryMonitorImpl {
    private static final Pattern SWAP = Pattern.compile("\\s+(\\d+)(MB|GB|KB)\\s+(\\d{1,2})%$");
    private static final Pattern MEM_USED = Pattern.compile("\\s+\\d+\\s+\\d+\\s+(\\d+)\\s+(\\d+)\\s+");
    private static final Pattern MEM_TOTAL = Pattern.compile("mem=(\\d+)(MB|GB)");

    @Override
    public MemoryUsage monitor() throws IOException {
        long[] v = this.getSwap();
        long[] m = this.getMemUsed();
        return new MemoryUsage(m[0], m[1], v[0], v[1]);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(MemoryMonitor.get().monitor());
    }

    private long[] getSwap() throws IOException {
        long[] v = new long[]{-1L, -1L};
        Process proc = this.startProcess("lsps", "-s");
        try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));){
            String line;
            while ((line = r.readLine()) != null) {
                Matcher m = SWAP.matcher(line);
                if (!m.find()) continue;
                long totalSwap = Long.parseLong(m.group(1));
                String unit = m.group(2);
                totalSwap = this.getSize(totalSwap, unit);
                long used = Long.parseLong(m.group(3));
                v[0] = totalSwap;
                if (used <= 0L) break;
                v[1] = totalSwap / 100L * (100L - used);
                break;
            }
            long[] lArray = v;
            return lArray;
        }
    }

    public long getSize(long totalSwap, String unit) {
        if ("MB".equals(unit)) {
            totalSwap = totalSwap * 1024L * 1024L;
        } else if ("GB".equals(unit)) {
            totalSwap = totalSwap * 1024L * 1024L;
        }
        return totalSwap;
    }

    private long[] getMemUsed() throws IOException {
        long[] v = new long[]{-1L, -1L};
        Process proc = this.startProcess("vmstat");
        try (BufferedReader r = new BufferedReader(new InputStreamReader(proc.getInputStream(), Charset.defaultCharset()));){
            String line;
            while ((line = r.readLine()) != null) {
                Matcher m = MEM_TOTAL.matcher(line);
                if (m.find()) {
                    long mem = Long.parseLong(m.group(1));
                    String unit = m.group(2);
                    v[0] = mem = this.getSize(mem, unit);
                    continue;
                }
                m = MEM_USED.matcher(line);
                if (!m.find()) continue;
                long free = Long.parseLong(m.group(2));
                v[1] = free * 4096L;
                break;
            }
            long[] lArray = v;
            return lArray;
        }
    }

    private Process startProcess(String ... cmd) throws IOException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process proc = pb.start();
        proc.getOutputStream().close();
        return proc;
    }
}

