/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.jvnet.hudson.MemoryMonitor;
import org.jvnet.hudson.MemoryUsage;

final class ProcMemInfo
extends MemoryMonitor {
    private static final String[] HEADERS = new String[]{"MemTotal:", "MemFree:", "SwapTotal:", "SwapFree:"};
    private static final Suffix[] SUFFIXES = new Suffix[]{new Suffix("KB", 1024L), new Suffix("MB", 0x100000L), new Suffix("GB", 0x40000000L)};
    private static final Suffix NONE = new Suffix("", 1L);

    ProcMemInfo() {
    }

    @Override
    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"}, justification="FileReader(String, Charset) requires Java 11")
    public MemoryUsage monitor() throws IOException {
        try (BufferedReader r = new BufferedReader(new FileReader("/proc/meminfo"));){
            String line;
            long[] values = new long[4];
            Arrays.fill(values, -1L);
            block11: while ((line = r.readLine()) != null) {
                for (int i = 0; i < HEADERS.length; ++i) {
                    if (!line.startsWith(HEADERS[i])) continue;
                    String s = line.substring(HEADERS[i].length()).trim();
                    Suffix suffix = Suffix.find(s);
                    s = s.substring(0, s.length() - suffix.name.length()).trim();
                    try {
                        values[i] = Long.parseLong(s) * suffix.multiplier;
                        continue block11;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Failed to parse: '" + s + "' out of '" + line + "'");
                    }
                }
            }
            MemoryUsage memoryUsage = new MemoryUsage(values);
            return memoryUsage;
        }
    }

    private static class Suffix {
        final String name;
        final long multiplier;

        private Suffix(String name, long multiplier) {
            this.name = name;
            this.multiplier = multiplier;
        }

        static Suffix find(String line) {
            for (Suffix s : SUFFIXES) {
                if (!line.substring(line.length() - s.name.length()).equalsIgnoreCase(s.name)) continue;
                return s;
            }
            return NONE;
        }
    }
}

