/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.instance_identity;

import hudson.FilePath;
import hudson.model.Hudson;
import hudson.model.PageDecorator;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.openssl.PEMReader;
import org.bouncycastle.openssl.PEMWriter;
import org.jenkinsci.main.modules.instance_identity.PageDecoratorImpl;

public class InstanceIdentity {
    private final KeyPair keys;
    private static final Logger LOGGER = Logger.getLogger(InstanceIdentity.class.getName());

    public InstanceIdentity() throws IOException {
        this(new File(Hudson.getInstance().getRootDir(), "identity.key"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InstanceIdentity(File keyFile) throws IOException {
        block9: {
            try {
                if (keyFile.exists()) {
                    FileReader in = new FileReader(keyFile);
                    try {
                        String provider = KeyPairGenerator.getInstance("RSA").getProvider().getName();
                        this.keys = (KeyPair)new PEMReader((Reader)in, null, provider).readObject();
                        break block9;
                    }
                    finally {
                        in.close();
                    }
                }
                KeyPairGenerator gen = KeyPairGenerator.getInstance("RSA");
                gen.initialize(2048, new SecureRandom());
                this.keys = gen.generateKeyPair();
                PEMWriter w = new PEMWriter((Writer)new FileWriter(keyFile), "SunJCE");
                try {
                    w.writeObject((Object)this.keys);
                }
                finally {
                    w.close();
                }
                this.makeReadOnly(keyFile);
            }
            catch (NoSuchAlgorithmException e) {
                throw new AssertionError((Object)e);
            }
        }
    }

    private void makeReadOnly(File keyFile) {
        try {
            new FilePath(keyFile).chmod(384);
        }
        catch (Throwable e) {
            LOGGER.log(Level.WARNING, "Failed to make read only: " + keyFile, e);
        }
    }

    public RSAPublicKey getPublic() {
        return (RSAPublicKey)this.keys.getPublic();
    }

    public RSAPrivateKey getPrivate() {
        return (RSAPrivateKey)this.keys.getPrivate();
    }

    public static InstanceIdentity get() {
        return ((PageDecoratorImpl)((Object)Hudson.getInstance().getExtensionList(PageDecorator.class).get(PageDecoratorImpl.class))).identity;
    }
}

