/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.main.modules.sshd;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import jenkins.model.Jenkins;
import org.apache.sshd.server.Environment;
import org.apache.sshd.server.ExitCallback;
import org.apache.sshd.server.channel.ChannelSession;
import org.apache.sshd.server.command.Command;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerSessionAware;
import org.jenkinsci.main.modules.sshd.SshCommandFactory;

public abstract class AsynchronousCommand
implements Command,
ServerSessionAware,
Runnable {
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private ExitCallback callback;
    private SshCommandFactory.CommandLine cmdLine;
    private Thread thread;
    private ServerSession session;
    private Environment environment;

    protected AsynchronousCommand(SshCommandFactory.CommandLine cmdLine) {
        this.cmdLine = cmdLine;
    }

    public void setInputStream(InputStream in) {
        this.in = in;
    }

    public void setOutputStream(OutputStream out) {
        this.out = out;
    }

    public void setErrorStream(OutputStream err) {
        this.err = err;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    public OutputStream getErrorStream() {
        return this.err;
    }

    public SshCommandFactory.CommandLine getCmdLine() {
        return this.cmdLine;
    }

    public void setExitCallback(ExitCallback callback) {
        this.callback = callback;
    }

    public ServerSession getSession() {
        return this.session;
    }

    public void setSession(ServerSession session) {
        this.session = session;
    }

    @CheckForNull
    protected User getCurrentUser() {
        Jenkins jenkins = Jenkins.get();
        if (jenkins.isUseSecurity()) {
            return User.getById((String)this.getSession().getUsername(), (boolean)true);
        }
        return null;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public void start(ChannelSession channel, Environment env) throws IOException {
        this.start(env);
    }

    public void start(Environment env) throws IOException {
        this.environment = env;
        this.thread = new Thread(this);
        this.thread.setName("SSH command: " + this.cmdLine.getSingleLine());
        this.thread.start();
    }

    protected abstract int runCommand() throws Exception;

    @Override
    public void run() {
        try {
            int i;
            User user = this.getCurrentUser();
            if (user != null) {
                try (ACLContext ctx = ACL.as((User)user);){
                    i = this.runCommand();
                }
            } else {
                i = this.runCommand();
            }
            this.flushOutputs();
            this.callback.onExit(i);
        }
        catch (Exception e) {
            PrintWriter ps = new PrintWriter(new OutputStreamWriter(this.err, Charset.defaultCharset()));
            e.printStackTrace(ps);
            ps.flush();
            this.flushOutputs();
            this.callback.onExit(255, e.getMessage());
        }
    }

    private void flushOutputs() {
        try {
            this.out.flush();
            this.err.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void destroy(ChannelSession channel) throws Exception {
        this.destroy();
    }

    public void destroy() {
        Thread.currentThread().interrupt();
    }
}

