/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.User;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.plugins.audit_trail.AuditTrailPlugin;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import jenkins.model.Jenkins;
import jenkins.util.HttpServletFilter;

@Extension
public class AuditTrailFilter
implements HttpServletFilter {
    private static final Logger LOGGER = Logger.getLogger(AuditTrailFilter.class.getName());
    private static Pattern uriPattern = null;
    @CheckForNull
    private AuditTrailPlugin configuration;
    private final ExecutorService executorService = Executors.newSingleThreadExecutor();

    @Deprecated
    public AuditTrailFilter(AuditTrailPlugin plugin) {
        this.configuration = plugin;
    }

    public AuditTrailFilter() {
    }

    static void setPattern(String pattern) throws PatternSyntaxException {
        uriPattern = Pattern.compile(pattern);
        LOGGER.log(Level.FINE, "set pattern to {0}", pattern);
    }

    public boolean handle(HttpServletRequest req, HttpServletResponse rsp) throws IOException, ServletException {
        User user = User.current();
        this.executorService.submit(() -> this.logRequest(req, user));
        return false;
    }

    private void logRequest(HttpServletRequest request, User user) {
        Object uri = AuditTrailFilter.getPathInfo(request);
        if (uriPattern != null && uriPattern.matcher((CharSequence)uri).matches()) {
            String username;
            String remoteIP = request.getRemoteAddr();
            String extra = "";
            if (((String)uri).startsWith("/queue/item/")) {
                extra = this.extractInfoFromQueueItem((String)uri);
            } else if (((String)uri).startsWith("/queue/cancelItem")) {
                extra = this.getFormattedQueueItemUrlFromItemId(Integer.parseInt(request.getParameter("id")));
                uri = (String)uri + "?" + request.getQueryString();
            } else if (((String)uri).contains("/createItem")) {
                extra = this.formatExtraInfoString(request.getParameter("name"));
            }
            String string = user != null ? (this.isShouldDisplayUserName() ? user.getDisplayName() : user.getId()) : (username = "NA");
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, "Audit request {0} by user {1} from {2}", new Object[]{uri, username, remoteIP});
            }
            this.onRequest((String)uri, extra, username, remoteIP);
        } else {
            LOGGER.log(Level.FINEST, "Skip audit for request {0}", uri);
        }
    }

    private boolean isShouldDisplayUserName() {
        return this.configuration != null && this.configuration.shouldDisplayUserName();
    }

    @Initializer(after=InitMilestone.EXTENSIONS_AUGMENTED)
    public void initializeConfiguration() {
        this.configuration = (AuditTrailPlugin)((Object)ExtensionList.lookupSingleton(AuditTrailPlugin.class));
    }

    private String extractInfoFromQueueItem(String uri) {
        try {
            int itemId = Integer.parseInt(uri.substring(12, uri.indexOf(47, 13)));
            return this.getFormattedQueueItemUrlFromItemId(itemId);
        }
        catch (Exception e) {
            LOGGER.log(Level.FINEST, "Error occurred while parsing queue item", e);
            return "";
        }
    }

    private String getFormattedQueueItemUrlFromItemId(int itemId) {
        return this.formatExtraInfoString(Jenkins.get().getQueue().getItem((long)((long)itemId)).task.getUrl());
    }

    private String formatExtraInfoString(String toFormat) {
        return String.format(" (%s)", toFormat);
    }

    private void onRequest(String uri, String extra, String username, String remoteIP) {
        if (this.configuration != null) {
            for (AuditLogger logger : this.configuration.getLoggers()) {
                logger.log(uri + extra + " by " + username + " from " + remoteIP);
            }
        }
    }

    private static String getPathInfo(HttpServletRequest request) {
        return AuditTrailFilter.canonicalPath(request.getRequestURI().substring(request.getContextPath().length()));
    }

    private static String canonicalPath(String path) {
        ArrayList<String> r = new ArrayList<String>(Arrays.asList(path.split("/+")));
        int i = 0;
        while (i < r.size()) {
            if (((String)r.get(i)).length() == 0 || ((String)r.get(i)).equals(".")) {
                r.remove(i);
                continue;
            }
            if (((String)r.get(i)).equals("..")) {
                r.remove(i);
                if (i <= 0) continue;
                r.remove(i - 1);
                --i;
                continue;
            }
            ++i;
        }
        StringBuilder buf = new StringBuilder();
        if (path.startsWith("/")) {
            buf.append('/');
        }
        boolean first = true;
        for (String token : r) {
            if (!first) {
                buf.append('/');
            } else {
                first = false;
            }
            buf.append(token);
        }
        if (path.endsWith("/") && (buf.length() == 0 || buf.charAt(buf.length() - 1) != '/')) {
            buf.append('/');
        }
        return buf.toString();
    }
}

