/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.audit_trail;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsUseListener;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import hudson.Extension;
import hudson.model.Item;
import hudson.model.Node;
import hudson.model.Run;
import hudson.plugins.audit_trail.AuditLogger;
import hudson.plugins.audit_trail.AuditTrailPlugin;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;

@Extension
public class CredentialUsageListener
implements CredentialsUseListener {
    private static final Logger LOGGER = Logger.getLogger(CredentialUsageListener.class.getName());
    @Inject
    AuditTrailPlugin configuration;

    public void onUse(Credentials c, Run run) {
        if (!this.configuration.shouldLogCredentialsUsage()) {
            return;
        }
        StringBuilder builder = new StringBuilder(100);
        String runName = run.getExternalizableId();
        String runType = run.getClass().toString();
        builder.append(String.format("'%s' (%s) ", runName, runType));
        this.auditLog(c, builder);
    }

    public void onUse(Credentials c, Node node) {
        if (!this.configuration.shouldLogCredentialsUsage()) {
            return;
        }
        StringBuilder builder = new StringBuilder(100);
        String nodeName = node.getNodeName();
        String nodeType = node.getClass().toString();
        builder.append(String.format("'%s' (%s) ", nodeName, nodeType));
        this.auditLog(c, builder);
    }

    public void onUse(Credentials c, Item item) {
        if (!this.configuration.shouldLogCredentialsUsage()) {
            return;
        }
        StringBuilder builder = new StringBuilder(100);
        String runName = item.getFullName();
        String itemType = item.getClass().toString();
        builder.append(String.format("'%s' (%s) ", runName, itemType));
        this.auditLog(c, builder);
    }

    private void auditLog(Credentials c, StringBuilder builder) {
        String credsType = c.getClass().toString();
        if (c instanceof BaseStandardCredentials) {
            credsId = ((BaseStandardCredentials)c).getId();
            builder.append(String.format("used credentials '%s' (%s).", credsId, credsType));
        } else if (c instanceof IdCredentials) {
            credsId = ((IdCredentials)c).getId();
            builder.append(String.format("used credentials '%s' (%s).", credsId, credsType));
        } else {
            String noIdAvailableWarning = String.valueOf(builder) + "used an unsupported credentials type (" + credsType + ") whose ID cannot be audit-logged. Consider opening an issue.";
            Logger.getLogger(CredentialUsageListener.class.getName()).log(Level.WARNING, null, noIdAvailableWarning);
            builder.append("used credentials of type " + credsType + " (Note: Used fallback method for log as credentials type is not supported. See INFO log for more information).");
        }
        String log = builder.toString();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Detected credential usage, details: {0}", new Object[]{log});
        }
        for (AuditLogger logger : this.configuration.getLoggers()) {
            logger.log(log);
        }
    }
}

