/*
 * Decompiled with CFR 0.152.
 */
package jenkins.authentication.tokens.api;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import jenkins.authentication.tokens.api.AuthenticationTokenException;
import jenkins.authentication.tokens.api.AuthenticationTokenSource;
import jenkins.model.Jenkins;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AuthenticationTokens {
    private static final Logger LOGGER = Logger.getLogger(AuthenticationTokens.class.getName());

    private AuthenticationTokens() {
        throw new IllegalAccessError("Utility class");
    }

    public static <T> CredentialsMatcher matcher(Class<T> tokenClass) {
        ArrayList<CredentialsMatcher> matchers = new ArrayList<CredentialsMatcher>();
        for (AuthenticationTokenSource source : Jenkins.getInstance().getExtensionList(AuthenticationTokenSource.class)) {
            if (!source.produces(tokenClass)) continue;
            matchers.add(source.matcher());
        }
        return matchers.isEmpty() ? CredentialsMatchers.never() : CredentialsMatchers.anyOf((CredentialsMatcher[])matchers.toArray(new CredentialsMatcher[matchers.size()]));
    }

    @CheckForNull
    public static <T, C extends Credentials> T convert(@NonNull Class<T> type, @CheckForNull C credentials) {
        if (credentials == null) {
            return null;
        }
        TreeMap matches = new TreeMap(Collections.reverseOrder());
        for (AuthenticationTokenSource source : Jenkins.getInstance().getExtensionList(AuthenticationTokenSource.class)) {
            Integer score = source.score(type, credentials);
            if (score == null || matches.containsKey(score)) continue;
            matches.put(score, source);
        }
        for (AuthenticationTokenSource source : matches.values()) {
            if (!source.produces(type) || !source.consumes(credentials)) continue;
            AuthenticationTokenSource s = source;
            T token = null;
            try {
                token = s.convert(credentials);
            }
            catch (AuthenticationTokenException e) {
                LogRecord lr = new LogRecord(Level.FINE, "Could not convert credentials {0} into token of type {1} using source {2}: {3}");
                lr.setThrown(e);
                lr.setParameters(new Object[]{credentials, type, s, e.getMessage()});
                LOGGER.log(lr);
            }
            if (token == null) continue;
            return token;
        }
        return null;
    }
}

