/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.awscredentials;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.regions.DefaultAwsRegionProviderChain;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeAvailabilityZonesResult;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.cloudbees.jenkins.plugins.awscredentials.AmazonWebServicesCredentials;
import com.cloudbees.jenkins.plugins.awscredentials.BaseAmazonWebServicesCredentials;
import com.cloudbees.jenkins.plugins.awscredentials.Messages;
import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsScope;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ProxyConfiguration;
import hudson.Util;
import hudson.util.FormValidation;
import hudson.util.Secret;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class AWSCredentialsImpl
extends BaseAmazonWebServicesCredentials
implements AmazonWebServicesCredentials {
    private static final long serialVersionUID = -3167989896315282034L;
    private static final Logger LOGGER = Logger.getLogger(BaseAmazonWebServicesCredentials.class.getName());
    public static final int STS_CREDENTIALS_DURATION_SECONDS = 3600;
    private final String accessKey;
    private final Secret secretKey;
    private final String iamRoleArn;
    private final String iamExternalId;
    private final String iamMfaSerialNumber;
    private volatile Integer stsTokenDuration;

    public AWSCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String accessKey, @CheckForNull String secretKey, @CheckForNull String description) {
        this(scope, id, accessKey, secretKey, description, null, null, null);
    }

    public AWSCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String accessKey, @CheckForNull String secretKey, @CheckForNull String description, @CheckForNull String iamRoleArn, @CheckForNull String iamMfaSerialNumber) {
        this(scope, id, accessKey, secretKey, description, iamRoleArn, iamMfaSerialNumber, null);
    }

    @DataBoundConstructor
    public AWSCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String accessKey, @CheckForNull String secretKey, @CheckForNull String description, @CheckForNull String iamRoleArn, @CheckForNull String iamMfaSerialNumber, String iamExternalId) {
        super(scope, id, description);
        this.accessKey = Util.fixNull((String)accessKey);
        this.secretKey = Secret.fromString((String)secretKey);
        this.iamRoleArn = Util.fixNull((String)iamRoleArn);
        this.iamExternalId = Util.fixNull((String)iamExternalId);
        this.iamMfaSerialNumber = Util.fixNull((String)iamMfaSerialNumber);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public Secret getSecretKey() {
        return this.secretKey;
    }

    public String getIamRoleArn() {
        return this.iamRoleArn;
    }

    public String getIamExternalId() {
        return this.iamExternalId;
    }

    public String getIamMfaSerialNumber() {
        return this.iamMfaSerialNumber;
    }

    @NonNull
    public Integer getStsTokenDuration() {
        return this.stsTokenDuration == null ? DescriptorImpl.DEFAULT_STS_TOKEN_DURATION : this.stsTokenDuration;
    }

    @DataBoundSetter
    public void setStsTokenDuration(Integer stsTokenDuration) {
        this.stsTokenDuration = stsTokenDuration == null || stsTokenDuration.equals(DescriptorImpl.DEFAULT_STS_TOKEN_DURATION) ? null : stsTokenDuration;
    }

    public boolean requiresToken() {
        return !StringUtils.isBlank((String)this.iamMfaSerialNumber);
    }

    public AWSCredentials getCredentials() {
        BasicAWSCredentials initialCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey.getPlainText());
        if (StringUtils.isBlank((String)this.iamRoleArn)) {
            return initialCredentials;
        }
        Object baseProvider = StringUtils.isBlank((String)this.accessKey) && StringUtils.isBlank((String)this.secretKey.getPlainText()) ? null : new AWSStaticCredentialsProvider((AWSCredentials)initialCredentials);
        AWSSecurityTokenService client = AWSCredentialsImpl.buildStsClient((AWSCredentialsProvider)baseProvider);
        AssumeRoleRequest assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(this.iamRoleArn, this.iamExternalId).withDurationSeconds(this.getStsTokenDuration());
        AssumeRoleResult assumeResult = client.assumeRole(assumeRequest);
        return new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken());
    }

    private static String determineClientRegion() {
        String clientRegion = null;
        DefaultAwsRegionProviderChain sdkRegionLookup = new DefaultAwsRegionProviderChain();
        try {
            clientRegion = sdkRegionLookup.getRegion();
        }
        catch (RuntimeException e) {
            LOGGER.log(Level.WARNING, "Could not find default region using SDK lookup.", e);
        }
        if (clientRegion == null) {
            clientRegion = Regions.DEFAULT_REGION.getName();
        }
        return clientRegion;
    }

    @Override
    public AWSCredentials getCredentials(String mfaToken) {
        BasicAWSCredentials initialCredentials = new BasicAWSCredentials(this.accessKey, this.secretKey.getPlainText());
        AssumeRoleRequest assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(this.iamRoleArn, this.iamExternalId).withSerialNumber(this.iamMfaSerialNumber).withTokenCode(mfaToken).withDurationSeconds(this.getStsTokenDuration());
        AWSSecurityTokenService awsSecurityTokenService = AWSCredentialsImpl.getAWSSecurityTokenService((AWSCredentials)initialCredentials);
        AssumeRoleResult assumeResult = awsSecurityTokenService.assumeRole(assumeRequest);
        return new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken());
    }

    public void refresh() {
    }

    @Override
    public String getDisplayName() {
        if (StringUtils.isBlank((String)this.iamRoleArn)) {
            return this.accessKey;
        }
        return this.accessKey + ":" + this.iamRoleArn;
    }

    static AWSSecurityTokenService buildStsClient(AWSCredentialsProvider provider) {
        String clientRegion = AWSCredentialsImpl.determineClientRegion();
        AWSSecurityTokenServiceClientBuilder builder = (AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(clientRegion)).withClientConfiguration(AWSCredentialsImpl.getClientConfiguration());
        if (provider != null) {
            builder = (AWSSecurityTokenServiceClientBuilder)builder.withCredentials(provider);
        }
        return (AWSSecurityTokenService)builder.build();
    }

    private static AssumeRoleRequest createAssumeRoleRequest(String iamRoleArn, String iamExternalId) {
        AssumeRoleRequest retval = new AssumeRoleRequest().withRoleArn(iamRoleArn).withRoleSessionName("Jenkins");
        if (iamExternalId != null && !iamExternalId.isEmpty()) {
            return retval.withExternalId(iamExternalId);
        }
        return retval;
    }

    private static AWSSecurityTokenService getAWSSecurityTokenService(AWSCredentials awsCredentials) {
        ClientConfiguration clientConfiguration = AWSCredentialsImpl.getClientConfiguration();
        String clientRegion = AWSCredentialsImpl.determineClientRegion();
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(clientRegion)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider(awsCredentials))).withClientConfiguration(clientConfiguration)).build();
    }

    private static ClientConfiguration getClientConfiguration() {
        Jenkins instance = Jenkins.getInstanceOrNull();
        ProxyConfiguration proxy = instance != null ? instance.proxy : null;
        ClientConfiguration clientConfiguration = new ClientConfiguration();
        if (proxy != null && proxy.name != null && !proxy.name.isEmpty()) {
            clientConfiguration.setProxyHost(proxy.name);
            clientConfiguration.setProxyPort(proxy.port);
            clientConfiguration.setProxyUsername(proxy.getUserName());
            clientConfiguration.setProxyPassword(proxy.getPassword());
        }
        return clientConfiguration;
    }

    @Extension
    public static class DescriptorImpl
    extends CredentialsDescriptor {
        public static final Integer DEFAULT_STS_TOKEN_DURATION = 3600;

        public String getDisplayName() {
            return Messages.AWSCredentialsImpl_DisplayName();
        }

        public FormValidation doCheckSecretKey(@QueryParameter(value="accessKey") String accessKey, @QueryParameter(value="iamRoleArn") String iamRoleArn, @QueryParameter(value="iamExternalId") String iamExternalId, @QueryParameter(value="iamMfaSerialNumber") String iamMfaSerialNumber, @QueryParameter(value="iamMfaToken") String iamMfaToken, @QueryParameter(value="stsTokenDuration") Integer stsTokenDuration, @QueryParameter String secretKey) {
            if (StringUtils.isBlank((String)accessKey) && StringUtils.isBlank((String)secretKey)) {
                return FormValidation.ok();
            }
            if (StringUtils.isBlank((String)accessKey)) {
                return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifyAccessKeyId());
            }
            if (StringUtils.isBlank((String)secretKey)) {
                return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifySecretAccessKey());
            }
            BasicAWSCredentials awsCredentials = new BasicAWSCredentials(accessKey, Secret.fromString((String)secretKey).getPlainText());
            if (!StringUtils.isBlank((String)iamRoleArn)) {
                AssumeRoleRequest assumeRequest = AWSCredentialsImpl.createAssumeRoleRequest(iamRoleArn, iamExternalId).withDurationSeconds(stsTokenDuration);
                if (!StringUtils.isBlank((String)iamMfaSerialNumber)) {
                    if (StringUtils.isBlank((String)iamMfaToken)) {
                        return FormValidation.error((String)Messages.AWSCredentialsImpl_SpecifyMFAToken());
                    }
                    assumeRequest = assumeRequest.withSerialNumber(iamMfaSerialNumber).withTokenCode(iamMfaToken);
                }
                try {
                    AWSSecurityTokenService awsSecurityTokenService = AWSCredentialsImpl.getAWSSecurityTokenService((AWSCredentials)awsCredentials);
                    AssumeRoleResult assumeResult = awsSecurityTokenService.assumeRole(assumeRequest);
                    awsCredentials = new BasicSessionCredentials(assumeResult.getCredentials().getAccessKeyId(), assumeResult.getCredentials().getSecretAccessKey(), assumeResult.getCredentials().getSessionToken());
                }
                catch (RuntimeException e) {
                    LOGGER.log(Level.WARNING, "Unable to assume role [" + iamRoleArn + "] with request [" + assumeRequest + "]", e);
                    return FormValidation.error((String)(Messages.AWSCredentialsImpl_NotAbleToAssumeRole() + " Check the Jenkins log for more details"));
                }
            }
            AmazonEC2Client ec2 = new AmazonEC2Client((AWSCredentials)awsCredentials, AWSCredentialsImpl.getClientConfiguration());
            String region = "us-east-1";
            try {
                DescribeAvailabilityZonesResult zonesResult = ec2.describeAvailabilityZones();
                return FormValidation.ok((String)Messages.AWSCredentialsImpl_CredentialsValidWithAccessToNZones(zonesResult.getAvailabilityZones().size()));
            }
            catch (AmazonServiceException e) {
                if (401 == e.getStatusCode()) {
                    return FormValidation.warning((String)Messages.AWSCredentialsImpl_CredentialsInValid(e.getMessage()));
                }
                if (403 == e.getStatusCode()) {
                    return FormValidation.ok((String)Messages.AWSCredentialsImpl_CredentialsValidWithoutAccessToAwsServiceInZone(e.getServiceName(), region, e.getErrorMessage() + " (" + e.getErrorCode() + ")"));
                }
                return FormValidation.error((String)e.getMessage());
            }
            catch (AmazonClientException e) {
                return FormValidation.error((String)e.getMessage());
            }
        }
    }
}

