/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionListListener;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.model.View;
import hudson.model.ViewGroup;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.branch.MultiBranchProjectFactoryDescriptor;
import jenkins.branch.OrganizationFolder;
import jenkins.scm.api.SCMNavigatorDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class CustomOrganizationFolderDescriptor
extends TopLevelItemDescriptor {
    private static final Logger LOGGER = Logger.getLogger(CustomOrganizationFolderDescriptor.class.getName());
    public final SCMNavigatorDescriptor delegate;

    CustomOrganizationFolderDescriptor(SCMNavigatorDescriptor delegate) {
        super(TopLevelItem.class);
        this.delegate = delegate;
    }

    public String getId() {
        return OrganizationFolder.class.getName() + "." + this.delegate.getId();
    }

    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    public String getDescription() {
        return this.delegate.getDescription();
    }

    public String getCategoryId() {
        return this.delegate.getCategoryId();
    }

    public String getIconFilePathPattern() {
        return this.delegate.getIconFilePathPattern();
    }

    public TopLevelItem newInstance(ItemGroup parent, String name) {
        OrganizationFolder p = new OrganizationFolder(parent, name);
        p.getNavigators().add((Object)this.delegate.newInstance(name));
        return p;
    }

    public String toString() {
        return "CustomOrganizationFolderDescriptor[" + this.delegate.getId() + "]";
    }

    @Initializer(after=InitMilestone.PLUGINS_STARTED, before=InitMilestone.EXTENSIONS_AUGMENTED)
    public static void addSpecificDescriptors() {
        LOGGER.fine("ran addSpecificDescriptors");
        CustomOrganizationFolderDescriptor.doAddSpecificDescriptors();
        ExtensionList.lookup(MultiBranchProjectFactoryDescriptor.class).addListener((ExtensionListListener)new ListenerImpl());
    }

    private static void doAddSpecificDescriptors() {
        LOGGER.fine("ran doAddSpecificDescriptors");
        ArrayList<CustomOrganizationFolderDescriptor> old = new ArrayList<CustomOrganizationFolderDescriptor>();
        for (TopLevelItemDescriptor d : CustomOrganizationFolderDescriptor.all()) {
            if (!(d instanceof CustomOrganizationFolderDescriptor)) continue;
            old.add((CustomOrganizationFolderDescriptor)d);
        }
        LOGGER.log(Level.FINE, "clearing {0}", old);
        CustomOrganizationFolderDescriptor.all().removeAll(old);
        if (ExtensionList.lookup(MultiBranchProjectFactoryDescriptor.class).isEmpty()) {
            LOGGER.fine("no MultiBranchProjectFactoryDescriptor");
            return;
        }
        TopLevelItemDescriptor.all().size();
        for (TopLevelItemDescriptor d : ExtensionList.lookup(SCMNavigatorDescriptor.class)) {
            if (d.newInstance((String)null) == null) continue;
            LOGGER.log(Level.FINE, "adding {0}", d.getId());
            TopLevelItemDescriptor.all().add((Object)new CustomOrganizationFolderDescriptor((SCMNavigatorDescriptor)d));
        }
        LOGGER.fine("done");
    }

    @Extension
    public static class HideGeneric
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, Descriptor descriptor) {
            LOGGER.log(Level.FINER, "filtering {0}", descriptor.getId());
            return !(descriptor instanceof OrganizationFolder.DescriptorImpl) || !(context instanceof View) && !(context instanceof ViewGroup);
        }
    }

    private static class ListenerImpl
    extends ExtensionListListener {
        private ListenerImpl() {
        }

        public void onChange() {
            CustomOrganizationFolderDescriptor.doAddSpecificDescriptors();
        }
    }
}

