/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.computed.ChildObserver;
import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.XmlFile;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.Saveable;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.model.ViewGroup;
import hudson.scm.PollingResult;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.util.PersistedList;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.branch.Branch;
import jenkins.branch.BranchIndexingCause;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.BranchPropertyStrategy;
import jenkins.branch.BranchSource;
import jenkins.branch.MultiBranchProjectDescriptor;
import jenkins.branch.MultiBranchProjectEmptyView;
import jenkins.branch.OrganizationFolder;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadObserver;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceCriteria;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.impl.NullSCMSource;
import jenkins.triggers.SCMTriggerItem;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.kohsuke.stapler.StaplerRequest;
import org.kohsuke.stapler.StaplerResponse;
import org.kohsuke.stapler.export.Exported;

public abstract class MultiBranchProject<P extends Job<P, R>, R extends Run<P, R>>
extends ComputedFolder<P>
implements SCMSourceOwner {
    private static final Logger LOGGER = Logger.getLogger(MultiBranchProject.class.getName());
    private PersistedList<BranchSource> sources = new BranchSourceList(this);
    private transient NullSCMSource nullSCMSource;
    private BranchProjectFactory<P, R> factory;
    private static final Set<Permission> SUPPRESSED_PERMISSIONS = ImmutableSet.of((Object)Item.CONFIGURE, (Object)Item.DELETE, (Object)View.CONFIGURE, (Object)View.CREATE, (Object)View.DELETE);

    protected MultiBranchProject(ItemGroup parent, String name) {
        super(parent, name);
        this.init2();
    }

    public void onLoad(ItemGroup<? extends Item> parent, String name) throws IOException {
        super.onLoad(parent, name);
        this.init2();
    }

    private synchronized void init2() {
        if (this.sources == null) {
            this.sources = new PersistedList((Saveable)this);
        }
        if (this.nullSCMSource == null) {
            this.nullSCMSource = new NullSCMSource();
        }
        this.nullSCMSource.setOwner((SCMSourceOwner)this);
        for (SCMSource source : this.getSCMSources()) {
            source.setOwner((SCMSourceOwner)this);
        }
        BranchProjectFactory<P, R> factory = this.getProjectFactory();
        factory.setOwner(this);
    }

    @NonNull
    public synchronized BranchProjectFactory<P, R> getProjectFactory() {
        if (this.factory == null) {
            this.setProjectFactory(this.newProjectFactory());
        }
        return this.factory;
    }

    public synchronized void setProjectFactory(BranchProjectFactory<P, R> projectFactory) {
        ((Object)projectFactory).getClass();
        if (this.factory == projectFactory) {
            return;
        }
        if (this.factory != null) {
            this.factory.setOwner(null);
        }
        this.factory = projectFactory;
        this.factory.setOwner(this);
    }

    @NonNull
    protected abstract BranchProjectFactory<P, R> newProjectFactory();

    @NonNull
    public List<BranchSource> getSources() {
        if (this.sources != null) {
            return this.sources.toList();
        }
        return Collections.emptyList();
    }

    @NonNull
    public PersistedList<BranchSource> getSourcesList() {
        return this.sources;
    }

    @NonNull
    public List<SCMSource> getSCMSources() {
        ArrayList<SCMSource> result = new ArrayList<SCMSource>();
        if (this.sources != null) {
            for (BranchSource source : this.sources) {
                result.add(source.getSource());
            }
        }
        return result;
    }

    @CheckForNull
    public SCMSource getSCMSource(@CheckForNull String sourceId) {
        for (SCMSource source : this.getSCMSources()) {
            if (!source.getId().equals(sourceId)) continue;
            return source;
        }
        return this.nullSCMSource;
    }

    @CheckForNull
    public BranchPropertyStrategy getBranchPropertyStrategy(@NonNull SCMSource source) {
        for (BranchSource s : this.getSources()) {
            if (!s.getSource().equals((Object)source)) continue;
            return s.getStrategy();
        }
        return null;
    }

    @NonNull
    private Branch newBranch(@NonNull SCMSource source, @NonNull SCMHead head) {
        source.getClass();
        head.getClass();
        String sourceId = source.getId();
        if (NullSCMSource.ID.equals(sourceId)) {
            return new Branch.Dead(head, Collections.emptyList());
        }
        BranchPropertyStrategy strategy = this.getBranchPropertyStrategy(source);
        return new Branch(sourceId, head, source.build(head), strategy != null ? strategy.getPropertiesFor(head) : Collections.emptyList());
    }

    @CheckForNull
    public SCMSourceCriteria getSCMSourceCriteria(@NonNull SCMSource source) {
        return null;
    }

    public void onSCMSourceUpdated(@NonNull SCMSource source) {
        this.scheduleBuild(0, new BranchIndexingCause());
    }

    protected void computeChildren(final ChildObserver<P> observer, final TaskListener listener) throws IOException, InterruptedException {
        final BranchProjectFactory<P, R> _factory = this.getProjectFactory();
        for (final SCMSource source : this.getSCMSources()) {
            source.fetch(new SCMHeadObserver(){

                public void observe(@NonNull SCMHead head, @NonNull SCMRevision revision) {
                    Branch branch = MultiBranchProject.this.newBranch(source, head);
                    String rawName = branch.getName();
                    String encodedName = branch.getEncodedName();
                    Object project = (Job)observer.shouldUpdate(encodedName);
                    if (project != null) {
                        if (!_factory.isProject((Item)project)) {
                            listener.getLogger().println("Detected unsupported subitem " + project + ", skipping");
                            return;
                        }
                        boolean needSave = !branch.equals(_factory.getBranch(project));
                        _factory.decorate(_factory.setBranch(project, branch));
                        if (revision.isDeterministic()) {
                            SCMRevision lastBuild = _factory.getRevision(project);
                            if (!revision.equals((Object)lastBuild)) {
                                listener.getLogger().println("Changes detected in " + rawName + " (" + lastBuild + " \u2192 " + revision + ")");
                                needSave = true;
                                MultiBranchProject.this.scheduleBuild(_factory, project, revision, listener, rawName);
                            } else {
                                listener.getLogger().println("No changes detected in " + rawName + " (still at " + revision + ")");
                            }
                        } else {
                            SCMTriggerItem scmProject = SCMTriggerItem.SCMTriggerItems.asSCMTriggerItem((Item)project);
                            if (scmProject != null) {
                                PollingResult pollingResult = scmProject.poll(listener);
                                if (pollingResult.hasChanges()) {
                                    listener.getLogger().println("Changes detected in " + rawName);
                                    needSave = true;
                                    MultiBranchProject.this.scheduleBuild(_factory, project, revision, listener, rawName);
                                } else {
                                    listener.getLogger().println("No changes detected in " + rawName);
                                }
                            }
                        }
                        if (needSave) {
                            try {
                                project.save();
                            }
                            catch (IOException e) {
                                e.printStackTrace(listener.error("Could not save changes to " + rawName));
                            }
                        }
                        return;
                    }
                    if (!observer.mayCreate(encodedName)) {
                        listener.getLogger().println("Ignoring duplicate branch project " + rawName);
                        return;
                    }
                    project = _factory.newInstance(branch);
                    if (!project.getName().equals(encodedName)) {
                        throw new IllegalStateException("Name of created project " + project + " did not match expected " + encodedName);
                    }
                    if (!rawName.equals(encodedName) && project.getDisplayName().equals(encodedName)) {
                        try {
                            project.setDisplayName(rawName);
                        }
                        catch (IOException e) {
                            e.printStackTrace(listener.error("Could not save changes to " + rawName));
                        }
                    }
                    _factory.decorate(project);
                    observer.created((TopLevelItem)project);
                    MultiBranchProject.this.scheduleBuild(_factory, project, revision, listener, rawName);
                }
            }, listener);
        }
    }

    private void scheduleBuild(BranchProjectFactory<P, R> factory, P item, SCMRevision revision, TaskListener listener, String name) {
        if (ParameterizedJobMixIn.scheduleBuild2(item, (int)0, (Action[])new Action[]{new CauseAction((Cause)new BranchIndexingCause())}) != null) {
            listener.getLogger().println("Scheduled build for branch: " + name);
            try {
                factory.setRevisionHash(item, revision);
            }
            catch (IOException e) {
                e.printStackTrace(listener.error("Could not update last revision hash"));
            }
        } else {
            listener.getLogger().println("Did not schedule build for branch: " + name);
        }
    }

    protected Collection<P> orphanedItems(Collection<P> orphaned, TaskListener listener) throws IOException, InterruptedException {
        BranchProjectFactory<Job, R> _factory = this.getProjectFactory();
        for (Job project : orphaned) {
            if (!_factory.isProject((Item)project)) {
                listener.getLogger().println("Detected unsupported subitem " + project + ", skipping");
                continue;
            }
            Branch b = _factory.getBranch(project);
            if (b instanceof Branch.Dead) continue;
            _factory.decorate(_factory.setBranch(project, new Branch.Dead(b.getHead(), b.getProperties())));
        }
        return super.orphanedItems(orphaned, listener);
    }

    @CheckForNull
    public P getItem(String name) {
        String decoded;
        Job item;
        if (name == null) {
            return null;
        }
        if (name.indexOf(37) != -1 && (item = (Job)super.getItem(decoded = MultiBranchProject.rawDecode(name))) != null) {
            return (P)item;
        }
        return (P)((Job)super.getItem(name));
    }

    @Deprecated
    @CheckForNull
    public P getBranch(String name) {
        return this.getItem(name);
    }

    public ACL getACL() {
        final ACL acl = super.getACL();
        if (this.getParent() instanceof OrganizationFolder) {
            return new ACL(){

                public boolean hasPermission(Authentication a, Permission permission) {
                    if (ACL.SYSTEM.equals(a)) {
                        return true;
                    }
                    if (SUPPRESSED_PERMISSIONS.contains(permission)) {
                        return false;
                    }
                    return acl.hasPermission(a, permission);
                }
            };
        }
        return acl;
    }

    @NonNull
    public File getRootDirFor(P child) {
        File dir = super.getRootDirFor((TopLevelItem)child);
        if (!dir.isDirectory() && !dir.mkdirs()) {
            LOGGER.log(Level.WARNING, "Could not create directory {0}", dir);
        }
        return dir;
    }

    @NonNull
    public File getJobsDir() {
        return new File(this.getRootDir(), "branches");
    }

    @NonNull
    public File getComputationDir() {
        return new File(this.getRootDir(), "indexing");
    }

    @NonNull
    public MultiBranchProjectDescriptor getDescriptor() {
        return (MultiBranchProjectDescriptor)super.getDescriptor();
    }

    public synchronized BranchIndexing<P, R> getIndexing() {
        return (BranchIndexing)this.getComputation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void submit(StaplerRequest req, StaplerResponse rsp) throws IOException, ServletException, Descriptor.FormException {
        super.submit(req, rsp);
        MultiBranchProject multiBranchProject = this;
        synchronized (multiBranchProject) {
            JSONObject json = req.getSubmittedForm();
            this.sources.replaceBy((Collection)req.bindJSONToList(BranchSource.class, json.opt("sources")));
            for (SCMSource scmSource : this.getSCMSources()) {
                scmSource.setOwner((SCMSourceOwner)this);
            }
            this.setProjectFactory((BranchProjectFactory)((Object)req.bindJSON(BranchProjectFactory.class, json.getJSONObject("projectFactory"))));
            this.save();
        }
    }

    @Exported
    @NonNull
    public View getPrimaryView() {
        if (this.getItems().isEmpty()) {
            return this.getWelcomeView();
        }
        return super.getPrimaryView();
    }

    protected View getWelcomeView() {
        return new MultiBranchProjectEmptyView((ViewGroup)this);
    }

    public View getView(String name) {
        if (name.equals("Welcome")) {
            return this.getWelcomeView();
        }
        return super.getView(name);
    }

    public boolean isBuildable() {
        if (this.sources == null) {
            return false;
        }
        return !this.sources.isEmpty();
    }

    protected FolderComputation<P> createComputation(FolderComputation<P> previous) {
        return new BranchIndexing(this, (BranchIndexing)previous);
    }

    @NonNull
    public static String rawDecode(@NonNull String s) {
        byte[] bytes;
        try {
            bytes = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JLS specification mandates UTF-8 as a supported encoding", e);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            if (b == 37 && i + 2 < bytes.length) {
                int u = Character.digit((char)bytes[++i], 16);
                int l = Character.digit((char)bytes[++i], 16);
                if (u != -1 && l != -1) {
                    buffer.write((char)((u << 4) + l));
                    continue;
                }
                i -= 2;
            }
            buffer.write(b);
        }
        try {
            return new String(buffer.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("JLS specification mandates UTF-8 as a supported encoding", e);
        }
    }

    private static class BranchSourceList
    extends PersistedList<BranchSource> {
        BranchSourceList(MultiBranchProject<?, ?> owner) {
            super(owner);
        }

        protected void onModified() throws IOException {
            super.onModified();
            Iterator iterator = this.iterator();
            while (iterator.hasNext()) {
                BranchSource branchSource = (BranchSource)((Object)iterator.next());
                branchSource.getSource().setOwner((SCMSourceOwner)((MultiBranchProject)this.owner));
            }
        }
    }

    public static class BranchIndexing<P extends Job<P, R>, R extends Run<P, R>>
    extends FolderComputation<P> {
        public BranchIndexing(@NonNull MultiBranchProject<P, R> project, @CheckForNull BranchIndexing<P, R> previousIndexing) {
            super(project, previousIndexing);
        }

        public MultiBranchProject<P, R> getParent() {
            return (MultiBranchProject)super.getParent();
        }

        protected XmlFile getDataFile() {
            return new XmlFile(Items.XSTREAM, new File(this.getParent().getComputationDir(), "indexing.xml"));
        }

        public File getLogFile() {
            return new File(this.getParent().getComputationDir(), "indexing.log");
        }

        public String getDisplayName() {
            return "Branch Indexing";
        }

        public String getUrl() {
            return this.getParent().getUrl() + "indexing/";
        }

        public String getSearchUrl() {
            return "indexing/";
        }
    }
}

