/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.model.BallColor;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Item;
import hudson.model.Job;
import hudson.views.ListViewColumnDescriptor;
import hudson.views.StatusColumn;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.MultiBranchProjectViewHolder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class BranchStatusColumn
extends StatusColumn {
    @DataBoundConstructor
    public BranchStatusColumn() {
    }

    @Restricted(value={NoExternalUse.class})
    public BallColor iconColor(Item item) {
        Branch b;
        MultiBranchProject p;
        BranchProjectFactory factory;
        if (item.getParent() instanceof MultiBranchProject && (factory = (p = (MultiBranchProject)item.getParent()).getProjectFactory()).isProject(item) && (b = factory.getBranch(factory.asProject(item))) instanceof Branch.Dead) {
            return BallColor.DISABLED;
        }
        if (item instanceof Job) {
            return ((Job)item).getIconColor();
        }
        try {
            Method method = item.getClass().getMethod("getIconColor", new Class[0]);
            if (BallColor.class.isAssignableFrom(method.getReturnType())) {
                return (BallColor)method.invoke((Object)item, new Object[0]);
            }
            return null;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return null;
        }
    }

    @Extension
    public static class DescriptorVisibilityFilterImpl
    extends DescriptorVisibilityFilter {
        public boolean filter(Object context, @NonNull Descriptor descriptor) {
            return !(descriptor instanceof DescriptorImpl) || context instanceof MultiBranchProjectViewHolder.ViewImpl;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BranchStatusColumn_displayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

