/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.DefaultOrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategy;
import com.cloudbees.hudson.plugins.folder.computed.OrphanedItemStrategyDescriptor;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.TaskListener;
import hudson.model.TopLevelItem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import jenkins.branch.Messages;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.branch.OrganizationFolderProperty;
import jenkins.branch.OrganizationFolderPropertyDescriptor;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.DataBoundConstructor;

public class OrganizationChildOrphanedItemsProperty
extends OrganizationFolderProperty<OrganizationFolder> {
    private final OrphanedItemStrategy strategy;

    @DataBoundConstructor
    public OrganizationChildOrphanedItemsProperty(OrphanedItemStrategy strategy) {
        this.strategy = strategy != null ? strategy : new DefaultOrphanedItemStrategy(true, "", "");
    }

    public static OrganizationChildOrphanedItemsProperty newDefaultInstance() {
        return new OrganizationChildOrphanedItemsProperty(new Inherit());
    }

    public OrphanedItemStrategy getStrategy() {
        return this.strategy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void decorate(@NonNull MultiBranchProject<?, ?> child, @NonNull TaskListener listener) throws IOException {
        OrphanedItemStrategy strategy;
        if (this.strategy instanceof Inherit) {
            ItemGroup parent = child.getParent();
            if (!(parent instanceof OrganizationFolder)) return;
            strategy = ((OrganizationFolder)parent).getOrphanedItemStrategy();
        } else {
            strategy = this.strategy;
        }
        if (child.getOrphanedItemStrategy().getClass().equals(strategy.getClass()) && Items.XSTREAM2.toXML((Object)strategy).equals(Items.XSTREAM2.toXML((Object)child.getOrphanedItemStrategy()))) return;
        child.setOrphanedItemStrategy((OrphanedItemStrategy)Items.XSTREAM2.fromXML(Items.XSTREAM2.toXML((Object)strategy)));
    }

    @Restricted(value={NoExternalUse.class})
    public static final class Inherit
    extends OrphanedItemStrategy {
        @DataBoundConstructor
        public Inherit() {
        }

        public <I extends TopLevelItem> Collection<I> orphanedItems(ComputedFolder<I> owner, Collection<I> orphaned, TaskListener listener) throws IOException, InterruptedException {
            return orphaned;
        }

        @Restricted(value={NoExternalUse.class})
        @Extension
        public static final class DescriptorImpl
        extends OrphanedItemStrategyDescriptor {
            @NonNull
            public String getDisplayName() {
                return Messages.OrganizationChildOrphanedItemsProperty_Inherit();
            }

            public boolean isApplicable(Class<? extends ComputedFolder> folderType) {
                return false;
            }
        }
    }

    @Extension
    public static class DescriptorImpl
    extends OrganizationFolderPropertyDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.OrganizationChildOrphanedItemsProperty_DisplayName();
        }

        @Restricted(value={DoNotUse.class})
        @NonNull
        public List<OrphanedItemStrategyDescriptor> getStrategyDescriptors() {
            ArrayList<OrphanedItemStrategyDescriptor> result = new ArrayList<OrphanedItemStrategyDescriptor>();
            for (OrphanedItemStrategyDescriptor d : ExtensionList.lookup(OrphanedItemStrategyDescriptor.class)) {
                if (d instanceof Inherit.DescriptorImpl) {
                    result.add(0, d);
                    continue;
                }
                if (!d.isApplicable(MultiBranchProject.class)) continue;
                result.add(d);
            }
            return result;
        }
    }
}

