/*
 * Decompiled with CFR 0.152.
 */
package jenkins.branch;

import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.View;
import hudson.views.ViewJobFilter;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import jenkins.branch.Branch;
import jenkins.branch.BranchProjectFactory;
import jenkins.branch.MultiBranchProject;

public abstract class SimpleViewBranchFilter
extends ViewJobFilter {
    private final boolean processExclusions = this.isExcludedOverridden();

    public final List<TopLevelItem> filter(List<TopLevelItem> added, List<TopLevelItem> all, View filteringView) {
        ItemGroup itemGroup = filteringView.getOwner().getItemGroup();
        if (itemGroup instanceof MultiBranchProject) {
            MultiBranchProject project = (MultiBranchProject)itemGroup;
            BranchProjectFactory factory = project.getProjectFactory();
            if (this.processExclusions) {
                added.removeIf(i -> factory.isProject((Item)i) && this.isExcluded(factory.getBranch(factory.asProject((Item)i))));
            }
            for (TopLevelItem i2 : all) {
                if (!factory.isProject((Item)i2) || !this.isIncluded(factory.getBranch(factory.asProject((Item)i2)))) continue;
                added.add(i2);
            }
        } else {
            BranchProjectFactory factory;
            ItemGroup parent;
            if (this.processExclusions) {
                Iterator<TopLevelItem> iterator = added.iterator();
                while (iterator.hasNext()) {
                    TopLevelItem i3 = iterator.next();
                    parent = i3.getParent();
                    if (!(parent instanceof MultiBranchProject) || !(factory = ((MultiBranchProject)parent).getProjectFactory()).isProject((Item)i3) || !this.isExcluded(factory.getBranch(factory.asProject((Item)i3)))) continue;
                    iterator.remove();
                }
            }
            for (TopLevelItem i3 : all) {
                parent = i3.getParent();
                if (!(parent instanceof MultiBranchProject) || !(factory = ((MultiBranchProject)parent).getProjectFactory()).isProject((Item)i3) || !this.isIncluded(factory.getBranch(factory.asProject((Item)i3)))) continue;
                added.add(i3);
            }
        }
        return added;
    }

    public boolean isExcluded(Branch branch) {
        return false;
    }

    public abstract boolean isIncluded(Branch var1);

    private boolean isExcludedOverridden() {
        try {
            Method isExcluded = ((Object)((Object)this)).getClass().getMethod("isExcluded", Branch.class);
            return isExcluded.getDeclaringClass() != SimpleViewBranchFilter.class;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }
}

