/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.Messages;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.SCMHeadWithOwnerAndRepo;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepositoryType;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import java.io.ObjectStreamException;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadMigration;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import jenkins.scm.api.mixin.ChangeRequestSCMHead2;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;
import org.kohsuke.accmod.restrictions.NoExternalUse;

public class PullRequestSCMHead
extends SCMHead
implements ChangeRequestSCMHead2 {
    private static final String PR_BRANCH_PREFIX = "PR-";
    private static final long serialVersionUID = 1L;
    private final String repoOwner;
    private final String repository;
    private final String branchName;
    private final String number;
    private final String title;
    private final BranchSCMHead target;
    private final SCMHeadOrigin origin;
    private final ChangeRequestCheckoutStrategy strategy;

    public PullRequestSCMHead(String name, String repoOwner, String repository, String branchName, String number, String title, BranchSCMHead target, SCMHeadOrigin origin, ChangeRequestCheckoutStrategy strategy) {
        super(name);
        this.repoOwner = repoOwner;
        this.repository = repository;
        this.branchName = branchName;
        this.number = number;
        this.title = title;
        this.target = target;
        this.origin = origin;
        this.strategy = strategy;
    }

    public PullRequestSCMHead(String name, String repoOwner, String repository, String branchName, BitbucketPullRequest pr, SCMHeadOrigin origin, ChangeRequestCheckoutStrategy strategy) {
        super(name);
        this.repoOwner = repoOwner;
        this.repository = repository;
        this.branchName = branchName;
        this.number = pr.getId();
        this.title = pr.getTitle();
        this.target = new BranchSCMHead(pr.getDestination().getBranch().getName());
        this.origin = origin;
        this.strategy = strategy;
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public PullRequestSCMHead(String repoOwner, String repository, String branchName, String number, BranchSCMHead target, SCMHeadOrigin origin) {
        this(PR_BRANCH_PREFIX + number, null, repoOwner, repository, branchName, number, target, origin, ChangeRequestCheckoutStrategy.HEAD);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public PullRequestSCMHead(String repoOwner, String repository, String branchName, String number, String title, BranchSCMHead target, SCMHeadOrigin origin) {
        this(PR_BRANCH_PREFIX + number, repoOwner, repository, branchName, number, title, target, origin, ChangeRequestCheckoutStrategy.HEAD);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public PullRequestSCMHead(String repoOwner, String repository, String branchName, String number, BranchSCMHead target) {
        this(repoOwner, repository, branchName, number, target, null);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public PullRequestSCMHead(String repoOwner, String repository, String branchName, BitbucketPullRequest pr) {
        this(repoOwner, repository, branchName, pr, null);
    }

    @Deprecated
    @Restricted(value={DoNotUse.class})
    public PullRequestSCMHead(String repoOwner, String repository, String branchName, BitbucketPullRequest pr, SCMHeadOrigin origin) {
        this(PR_BRANCH_PREFIX + pr.getId(), repoOwner, repository, branchName, pr, origin, ChangeRequestCheckoutStrategy.HEAD);
    }

    @SuppressFBWarnings(value={"SE_PRIVATE_READ_RESOLVE_NOT_INHERITED"})
    private Object readResolve() throws ObjectStreamException {
        if ("\u0000".equals(this.getTarget().getName())) {
            return new SCMHeadWithOwnerAndRepo.PR(this.repoOwner, this.repository, this.getBranchName(), this.number, this.target);
        }
        if (this.origin == null || this.strategy == null) {
            return new FixLegacy(this);
        }
        return this;
    }

    public String getPronoun() {
        return Messages.PullRequestSCMHead_Pronoun();
    }

    public String getRepoOwner() {
        return this.repoOwner;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getBranchName() {
        return this.branchName;
    }

    public BitbucketRepositoryType getRepositoryType() {
        return this.target.getRepositoryType();
    }

    @NonNull
    public String getId() {
        return this.number;
    }

    public String getTitle() {
        return this.title;
    }

    @NonNull
    public SCMHead getTarget() {
        return this.target;
    }

    @NonNull
    public ChangeRequestCheckoutStrategy getCheckoutStrategy() {
        return this.strategy;
    }

    @NonNull
    public String getOriginName() {
        return this.branchName;
    }

    @NonNull
    public SCMHeadOrigin getOrigin() {
        return this.origin == null ? SCMHeadOrigin.DEFAULT : this.origin;
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    @Extension
    public static class FixLegacyMigration1
    extends SCMHeadMigration<BitbucketSCMSource, FixLegacy, AbstractGitSCMSource.SCMRevisionImpl> {
        public FixLegacyMigration1() {
            super(BitbucketSCMSource.class, FixLegacy.class, AbstractGitSCMSource.SCMRevisionImpl.class);
        }

        public PullRequestSCMHead migrate(@NonNull BitbucketSCMSource source, @NonNull FixLegacy head) {
            return new PullRequestSCMHead(head.getName(), head.getRepoOwner(), head.getRepository(), head.getBranchName(), head.getId(), head.getTitle(), (BranchSCMHead)head.getTarget(), source.originOf(head.getRepoOwner(), head.getRepository()), ChangeRequestCheckoutStrategy.HEAD);
        }

        public SCMRevision migrate(@NonNull BitbucketSCMSource source, @NonNull AbstractGitSCMSource.SCMRevisionImpl revision) {
            PullRequestSCMHead head = this.migrate(source, (FixLegacy)revision.getHead());
            return head != null ? new PullRequestSCMRevision(head, new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), null), new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, revision.getHash())) : null;
        }
    }

    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static class FixLegacy
    extends PullRequestSCMHead {
        FixLegacy(PullRequestSCMHead copy) {
            super(copy.getName(), copy.repoOwner, copy.repository, copy.branchName, copy.number, copy.getTitle(), copy.target, copy.getOrigin(), ChangeRequestCheckoutStrategy.HEAD);
        }
    }
}

