/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSourceContext;
import com.cloudbees.jenkins.plugins.bitbucket.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMRevision;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketRepository;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HasPullRequests;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.NativeServerHeadEvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.pullrequest.BitbucketServerPullRequest;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerRepository;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerPullRequestEvent;
import com.google.common.base.Ascii;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMEvent;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMHeadEvent;
import jenkins.scm.api.SCMHeadOrigin;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;

public class NativeServerPullRequestHookProcessor
extends HookProcessor {
    private static final Logger LOGGER = Logger.getLogger(NativeServerPullRequestHookProcessor.class.getName());

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin) {
    }

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin, String serverUrl) {
        SCMEvent.Type eventType;
        NativeServerPullRequestEvent pullRequestEvent;
        try {
            pullRequestEvent = JsonParser.toJava(payload, NativeServerPullRequestEvent.class);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
            return;
        }
        switch (hookEvent) {
            case SERVER_PULL_REQUEST_OPENED: {
                eventType = SCMEvent.Type.CREATED;
                break;
            }
            case SERVER_PULL_REQUEST_MERGED: 
            case SERVER_PULL_REQUEST_DECLINED: 
            case SERVER_PULL_REQUEST_DELETED: {
                eventType = SCMEvent.Type.REMOVED;
                break;
            }
            case SERVER_PULL_REQUEST_MODIFIED: 
            case SERVER_PULL_REQUEST_REVIEWER_UPDATED: 
            case SERVER_PULL_REQUEST_FROM_REF_UPDATED: {
                eventType = SCMEvent.Type.UPDATED;
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Unknown hook event {0} received from Bitbucket Server", (Object)hookEvent);
                return;
            }
        }
        SCMHeadEvent.fireLater((SCMHeadEvent)new HeadEvent(serverUrl, eventType, pullRequestEvent, origin), (long)BitbucketSCMSource.getEventDelaySeconds(), (TimeUnit)TimeUnit.SECONDS);
    }

    private static final class HeadEvent
    extends NativeServerHeadEvent<NativeServerPullRequestEvent>
    implements HasPullRequests {
        private HeadEvent(String serverUrl, SCMEvent.Type type, NativeServerPullRequestEvent payload, String origin) {
            super(serverUrl, type, payload, origin);
        }

        @Override
        protected BitbucketServerRepository getRepository() {
            return ((NativeServerPullRequestEvent)this.getPayload()).getPullRequest().getDestination().getRepository();
        }

        @Override
        @NonNull
        protected Map<SCMHead, SCMRevision> heads(@NonNull BitbucketSCMSource source) {
            if (!this.eventMatchesRepo(source)) {
                return Collections.emptyMap();
            }
            BitbucketSCMSourceContext ctx = this.contextOf(source);
            if (!ctx.wantPRs()) {
                return Collections.emptyMap();
            }
            BitbucketServerPullRequest pullRequest = ((NativeServerPullRequestEvent)this.getPayload()).getPullRequest();
            BitbucketRepository sourceRepo = pullRequest.getSource().getRepository();
            SCMHeadOrigin headOrigin = source.originOf(sourceRepo.getOwnerName(), sourceRepo.getRepositoryName());
            Set<ChangeRequestCheckoutStrategy> strategies = headOrigin == SCMHeadOrigin.DEFAULT ? ctx.originPRStrategies() : ctx.forkPRStrategies();
            HashMap<SCMHead, SCMRevision> result = new HashMap<SCMHead, SCMRevision>(strategies.size());
            for (ChangeRequestCheckoutStrategy strategy : strategies) {
                String originalBranchName = pullRequest.getSource().getBranch().getName();
                String branchName = String.format("PR-%s%s", pullRequest.getId(), strategies.size() > 1 ? "-" + Ascii.toLowerCase((String)strategy.name()) : "");
                PullRequestSCMHead head = new PullRequestSCMHead(branchName, sourceRepo.getOwnerName(), sourceRepo.getRepositoryName(), originalBranchName, pullRequest, headOrigin, strategy);
                switch (this.getType()) {
                    case CREATED: 
                    case UPDATED: {
                        String targetHash = pullRequest.getDestination().getCommit().getHash();
                        String pullHash = pullRequest.getSource().getCommit().getHash();
                        result.put(head, (SCMRevision)new PullRequestSCMRevision(head, new AbstractGitSCMSource.SCMRevisionImpl(head.getTarget(), targetHash), new AbstractGitSCMSource.SCMRevisionImpl((SCMHead)head, pullHash)));
                        break;
                    }
                    case REMOVED: {
                        result.put(head, null);
                        break;
                    }
                }
            }
            return result;
        }

        @Override
        public Iterable<BitbucketPullRequest> getPullRequests(BitbucketSCMSource src) throws InterruptedException {
            if (SCMEvent.Type.REMOVED.equals((Object)this.getType())) {
                return Collections.emptySet();
            }
            return Collections.singleton(((NativeServerPullRequestEvent)this.getPayload()).getPullRequest());
        }
    }
}

