/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.api;

import com.fasterxml.jackson.annotation.JsonIgnore;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.DoNotUse;

public class BitbucketBuildStatus {
    @JsonIgnore
    private String hash;
    private String description;
    private Status state;
    private String url;
    private String key;
    private String parent;
    private String name;
    private String refname;
    private long buildDuration;
    private int buildNumber;

    @Restricted(value={DoNotUse.class})
    public BitbucketBuildStatus() {
    }

    public BitbucketBuildStatus(String hash, String description, @NonNull Status state, String url, @NonNull String key, String name, @Nullable String refname) {
        this.hash = hash;
        this.description = description;
        this.state = state;
        this.url = url;
        this.key = key;
        this.name = name;
        this.refname = refname;
    }

    public BitbucketBuildStatus(@NonNull BitbucketBuildStatus other) {
        this.hash = other.hash;
        this.description = other.description;
        this.state = other.state;
        this.url = other.url;
        this.key = other.key;
        this.name = other.name;
        this.refname = other.refname;
        this.buildDuration = other.buildDuration;
        this.parent = other.parent;
    }

    public String getHash() {
        return this.hash;
    }

    public void setHash(String hash) {
        this.hash = hash;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getState() {
        return this.state.toString();
    }

    public void setState(Status state) {
        this.state = state;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getRefname() {
        return this.refname;
    }

    public void setRefname(String refname) {
        this.refname = refname;
    }

    public long getBuildDuration() {
        return this.buildDuration;
    }

    public void setBuildDuration(long buildDuration) {
        this.buildDuration = buildDuration;
    }

    public int getBuildNumber() {
        return this.buildNumber;
    }

    public void setBuildNumber(int buildNumber) {
        this.buildNumber = buildNumber;
    }

    public void setParent(String parent) {
        this.parent = parent;
    }

    public String getParent() {
        return this.parent;
    }

    public static enum Status {
        INPROGRESS("INPROGRESS"),
        FAILED("FAILED"),
        STOPPED("STOPPED"),
        CANCELLED("CANCELLED"),
        SUCCESSFUL("SUCCESSFUL");

        private final String status;

        private Status(String status) {
            this.status = status;
        }

        public String toString() {
            return this.status;
        }
    }
}

