/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.endpoints;

import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketCredentials;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.URLUtils;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.model.Jenkins;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.displayurlapi.DisplayURLProvider;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.DataBoundSetter;

public abstract class AbstractBitbucketEndpoint
implements BitbucketEndpoint {
    private final boolean manageHooks;
    @CheckForNull
    private final String credentialsId;
    private boolean enableHookSignature;
    @CheckForNull
    private String hookSignatureCredentialsId;
    private String bitbucketJenkinsRootUrl;

    AbstractBitbucketEndpoint(boolean manageHooks, @CheckForNull String credentialsId, boolean enableHookSignature, @CheckForNull String hookSignatureCredentialsId) {
        this.manageHooks = manageHooks && StringUtils.isNotBlank((CharSequence)credentialsId);
        this.credentialsId = manageHooks ? Util.fixEmptyAndTrim((String)credentialsId) : null;
        this.enableHookSignature = enableHookSignature && StringUtils.isNotBlank((CharSequence)hookSignatureCredentialsId);
        this.hookSignatureCredentialsId = enableHookSignature ? Util.fixEmptyAndTrim((String)hookSignatureCredentialsId) : null;
    }

    @Deprecated(since="936.4.0", forRemoval=true)
    @NonNull
    public abstract String getServerUrl();

    @NonNull
    static String normalizeJenkinsRootUrl(String rootUrl) {
        return Util.ensureEndsWith((String)URLUtils.normalizeURL(Util.fixEmptyAndTrim((String)rootUrl)), (String)"/");
    }

    @Deprecated(since="936.4.0", forRemoval=true)
    @CheckForNull
    public String getBitbucketJenkinsRootUrl() {
        return this.bitbucketJenkinsRootUrl;
    }

    @Override
    public String getEndpointJenkinsRootURL() {
        return this.getBitbucketJenkinsRootUrl();
    }

    @Override
    @NonNull
    public String getRepositoryURL(@NonNull String repoOwner, @NonNull String repoSlug) {
        return this.getRepositoryUrl(repoOwner, repoSlug);
    }

    @DataBoundSetter
    public void setBitbucketJenkinsRootUrl(String bitbucketJenkinsRootUrl) {
        this.bitbucketJenkinsRootUrl = this.manageHooks ? AbstractBitbucketEndpoint.normalizeJenkinsRootUrl(bitbucketJenkinsRootUrl) : null;
    }

    @Override
    @CheckForNull
    public String getHookSignatureCredentialsId() {
        return this.hookSignatureCredentialsId;
    }

    @Override
    public boolean isEnableHookSignature() {
        return this.enableHookSignature;
    }

    @Deprecated(since="936.4.0", forRemoval=true)
    @NonNull
    public String getEndpointJenkinsRootUrl() {
        if (StringUtils.isBlank((CharSequence)this.bitbucketJenkinsRootUrl)) {
            return DisplayURLProvider.get().getRoot();
        }
        return this.bitbucketJenkinsRootUrl;
    }

    @NonNull
    public static String getEndpointJenkinsRootUrl(String serverURL) {
        String endpointURL = null;
        BitbucketEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(serverURL).orElse(null);
        if (endpoint != null) {
            endpointURL = endpoint.getEndpointJenkinsRootURL();
        }
        if (endpointURL == null) {
            endpointURL = DisplayURLProvider.get().getRoot();
        }
        return endpointURL;
    }

    @NonNull
    public abstract String getRepositoryUrl(@NonNull String var1, @NonNull String var2);

    @Override
    public final boolean isManageHooks() {
        return this.manageHooks;
    }

    @Override
    @CheckForNull
    public final String getCredentialsId() {
        return this.credentialsId;
    }

    @Override
    @CheckForNull
    public StandardCredentials credentials() {
        return BitbucketCredentials.lookupCredentials(this.getServerUrl(), Jenkins.get(), this.credentialsId, StandardCredentials.class);
    }

    @Override
    @CheckForNull
    public StringCredentials hookSignatureCredentials() {
        return BitbucketCredentials.lookupCredentials(this.getServerUrl(), Jenkins.get(), this.hookSignatureCredentialsId, StringCredentials.class);
    }

    @CheckForNull
    public BitbucketAuthenticator authenticator() {
        return (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(this.getServerURL()), (Credentials)this.credentials());
    }

    @Override
    public AbstractBitbucketEndpointDescriptor getDescriptor() {
        return (AbstractBitbucketEndpointDescriptor)Jenkins.get().getDescriptorOrDie(this.getClass());
    }
}

