/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.endpoints;

import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.EndpointType;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudApiClient;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.AbstractBitbucketEndpointDescriptor;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.Messages;
import com.damnhandy.uri.template.UriTemplate;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.util.FormValidation;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.verb.POST;

public class BitbucketCloudEndpoint
extends AbstractBitbucketEndpoint {
    public static final String SERVER_URL = "https://bitbucket.org";
    private final boolean enableCache;
    private final int teamCacheDuration;
    private final int repositoriesCacheDuration;

    public BitbucketCloudEndpoint() {
        this(false, 0, 0, false, null, false, null);
    }

    @Deprecated(since="936.3.1")
    public BitbucketCloudEndpoint(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, boolean manageHooks, @CheckForNull String credentialsId) {
        this(enableCache, teamCacheDuration, repositoriesCacheDuration, manageHooks, credentialsId, false, null);
    }

    @DataBoundConstructor
    public BitbucketCloudEndpoint(boolean enableCache, int teamCacheDuration, int repositoriesCacheDuration, boolean manageHooks, @CheckForNull String credentialsId, boolean enableHookSignature, @CheckForNull String hookSignatureCredentialsId) {
        super(manageHooks, credentialsId, enableHookSignature, hookSignatureCredentialsId);
        this.enableCache = enableCache;
        this.teamCacheDuration = teamCacheDuration;
        this.repositoriesCacheDuration = repositoriesCacheDuration;
    }

    public boolean isEnableCache() {
        return this.enableCache;
    }

    public int getTeamCacheDuration() {
        return this.teamCacheDuration;
    }

    public int getRepositoriesCacheDuration() {
        return this.repositoriesCacheDuration;
    }

    @Override
    public String getDisplayName() {
        return Messages.BitbucketCloudEndpoint_displayName();
    }

    @Override
    @Deprecated(since="936.4.0", forRemoval=true)
    @NonNull
    public String getServerUrl() {
        return SERVER_URL;
    }

    @Override
    public String getServerURL() {
        return this.getServerUrl();
    }

    @Override
    @NonNull
    public String getRepositoryUrl(@NonNull String repoOwner, @NonNull String repository) {
        UriTemplate template = UriTemplate.fromTemplate((String)"https://bitbucket.org{/owner,repo}").set("owner", (Object)repoOwner).set("repo", (Object)repository);
        return template.expand();
    }

    @Override
    public EndpointType getType() {
        return EndpointType.CLOUD;
    }

    private Object readResolve() {
        if (this.getBitbucketJenkinsRootUrl() != null) {
            this.setBitbucketJenkinsRootUrl(this.getBitbucketJenkinsRootUrl());
        }
        return this;
    }

    @Extension
    public static class DescriptorImpl
    extends AbstractBitbucketEndpointDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.BitbucketCloudEndpoint_displayName();
        }

        public FormValidation doShowStats() {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
            List<String> stats = BitbucketCloudApiClient.stats();
            StringBuilder builder = new StringBuilder();
            for (String stat : stats) {
                builder.append(stat).append("<br>");
            }
            return FormValidation.okWithMarkup((String)builder.toString());
        }

        @POST
        public FormValidation doClear() {
            Jenkins.get().checkPermission(Jenkins.MANAGE);
            BitbucketCloudApiClient.clearCaches();
            return FormValidation.ok((String)"Caches cleared");
        }
    }
}

