/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.filesystem;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.BitbucketTagSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.BranchSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.PullRequestSCMHead;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApi;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketApiFactory;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketAuthenticator;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketCommit;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.filesystem.BitbucketSCMFile;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.DateUtils;
import com.cloudbees.jenkins.plugins.bitbucket.server.BitbucketServerVersion;
import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardCredentials;
import com.cloudbees.plugins.credentials.domains.URIRequirementBuilder;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.model.Item;
import hudson.model.Queue;
import hudson.plugins.git.GitSCM;
import hudson.scm.SCM;
import hudson.scm.SCMDescriptor;
import hudson.security.ACL;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import jenkins.authentication.tokens.api.AuthenticationTokens;
import jenkins.plugins.git.AbstractGitSCMSource;
import jenkins.scm.api.SCMFile;
import jenkins.scm.api.SCMFileSystem;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMRevision;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceDescriptor;
import jenkins.scm.api.mixin.ChangeRequestCheckoutStrategy;
import org.apache.commons.lang3.StringUtils;
import org.springframework.security.core.Authentication;

public class BitbucketSCMFileSystem
extends SCMFileSystem {
    private final String ref;
    private final BitbucketApi api;

    protected BitbucketSCMFileSystem(BitbucketApi api, String ref, @CheckForNull SCMRevision rev) {
        super(rev);
        this.ref = ref;
        this.api = api;
    }

    public long lastModified() throws IOException {
        return 0L;
    }

    @NonNull
    public SCMFile getRoot() {
        SCMRevision revision = this.getRevision();
        return new BitbucketSCMFile(this.api, this.ref, revision == null ? null : revision.toString());
    }

    public void close() throws IOException {
        if (this.api != null) {
            this.api.close();
        }
    }

    public boolean changesSince(@CheckForNull SCMRevision fromRevision, @NonNull OutputStream changeLogStream) throws UnsupportedOperationException, IOException, InterruptedException {
        SCMRevision currentRevision = this.getRevision();
        if (Objects.equals(currentRevision, fromRevision)) {
            return false;
        }
        int count = 0;
        StringBuilder log = new StringBuilder(1024);
        String startHash = null;
        if (fromRevision instanceof AbstractGitSCMSource.SCMRevisionImpl) {
            AbstractGitSCMSource.SCMRevisionImpl gitRev = (AbstractGitSCMSource.SCMRevisionImpl)fromRevision;
            startHash = gitRev.getHash();
        }
        for (BitbucketCommit bitbucketCommit : this.api.getCommits(startHash, this.ref)) {
            log.setLength(0);
            log.append("commit ").append(bitbucketCommit.getHash()).append('\n');
            log.append("parent ").append(StringUtils.join(bitbucketCommit.getParents(), (String)" ")).append('\n');
            log.append("author ").append(bitbucketCommit.getAuthor()).append(' ').append(StringUtils.defaultString((String)DateUtils.formatToISO(bitbucketCommit.getAuthorDate()))).append('\n');
            log.append("committer ").append(bitbucketCommit.getAuthor()).append(' ').append(StringUtils.defaultString((String)DateUtils.formatToISO(bitbucketCommit.getCommitterDate()))).append('\n');
            log.append('\n');
            String msg = bitbucketCommit.getMessage();
            if (msg.endsWith("\r\n")) {
                msg = msg.substring(0, msg.length() - 2);
            } else if (msg.endsWith("\n")) {
                msg = msg.substring(0, msg.length() - 1);
            }
            msg = msg.replace("\r\n", "\n").replace("\r", "\n").replace("\n", "\n    ");
            log.append("    ").append(msg).append('\n');
            changeLogStream.write(log.toString().getBytes(StandardCharsets.UTF_8));
            changeLogStream.flush();
            if (++count < GitSCM.MAX_CHANGELOG) continue;
            break;
        }
        return count > 0;
    }

    @Extension
    public static class BuilderImpl
    extends SCMFileSystem.Builder {
        public boolean supports(SCM source) {
            return false;
        }

        public boolean supports(SCMSource source) {
            return source instanceof BitbucketSCMSource;
        }

        protected boolean supportsDescriptor(SCMDescriptor scmDescriptor) {
            return false;
        }

        protected boolean supportsDescriptor(SCMSourceDescriptor scmSourceDescriptor) {
            return scmSourceDescriptor instanceof BitbucketSCMSource.DescriptorImpl;
        }

        public SCMFileSystem build(@NonNull Item owner, @NonNull SCM scm, @CheckForNull SCMRevision rev) {
            return null;
        }

        private static StandardCredentials lookupScanCredentials(@CheckForNull Item context, @CheckForNull String scanCredentialsId, String serverURL) {
            Authentication authentication;
            if ((scanCredentialsId = Util.fixEmpty((String)scanCredentialsId)) == null) {
                return null;
            }
            if (context instanceof Queue.Task) {
                Queue.Task task = (Queue.Task)context;
                authentication = task.getDefaultAuthentication2();
            } else {
                authentication = ACL.SYSTEM2;
            }
            return (StandardCredentials)CredentialsMatchers.firstOrNull((Iterable)CredentialsProvider.lookupCredentialsInItem(StandardCredentials.class, (Item)context, (Authentication)authentication, (List)URIRequirementBuilder.fromUri((String)serverURL).build()), (CredentialsMatcher)CredentialsMatchers.allOf((CredentialsMatcher[])new CredentialsMatcher[]{CredentialsMatchers.withId((String)scanCredentialsId), AuthenticationTokens.matcher(BitbucketAuthenticator.authenticationContext(serverURL))}));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public SCMFileSystem build(@NonNull SCMSource source, @NonNull SCMHead head, @CheckForNull SCMRevision rev) throws IOException, InterruptedException {
            BitbucketSCMSource src = (BitbucketSCMSource)source;
            String credentialsId = src.getCredentialsId();
            String owner = src.getRepoOwner();
            String repository = src.getRepository();
            String serverURL = src.getServerUrl();
            StandardCredentials credentials = BuilderImpl.lookupScanCredentials((Item)src.getOwner(), credentialsId, serverURL);
            BitbucketAuthenticator authenticator = (BitbucketAuthenticator)AuthenticationTokens.convert(BitbucketAuthenticator.authenticationContext(serverURL), (Credentials)credentials);
            Object ref = null;
            if (head instanceof BranchSCMHead) {
                ref = head.getName();
                return new BitbucketSCMFileSystem(BitbucketApiFactory.newInstance(serverURL, authenticator, owner, null, repository), (String)ref, rev);
            } else if (head instanceof PullRequestSCMHead) {
                PullRequestSCMHead prHead = (PullRequestSCMHead)head;
                if (prHead.getRepository() == null) {
                    return null;
                }
                if (BitbucketApiUtils.isCloud(serverURL)) {
                    if (prHead.getCheckoutStrategy() != ChangeRequestCheckoutStrategy.HEAD) return null;
                    if (!StringUtils.equalsIgnoreCase((CharSequence)prHead.getRepoOwner(), (CharSequence)src.getRepoOwner())) return null;
                    if (!prHead.getRepository().equals(src.getRepository())) return null;
                    ref = prHead.getOriginName();
                    return new BitbucketSCMFileSystem(BitbucketApiFactory.newInstance(serverURL, authenticator, owner, null, repository), (String)ref, rev);
                } else if (prHead.getCheckoutStrategy() == ChangeRequestCheckoutStrategy.HEAD) {
                    ref = "pull-requests/" + prHead.getId() + "/from";
                    return new BitbucketSCMFileSystem(BitbucketApiFactory.newInstance(serverURL, authenticator, owner, null, repository), (String)ref, rev);
                } else {
                    if (prHead.getCheckoutStrategy() != ChangeRequestCheckoutStrategy.MERGE) return new BitbucketSCMFileSystem(BitbucketApiFactory.newInstance(serverURL, authenticator, owner, null, repository), (String)ref, rev);
                    if (BitbucketServerEndpoint.findServerVersion(serverURL) == BitbucketServerVersion.VERSION_7) return null;
                    boolean bl = true;
                    boolean ligthCheckout = bl;
                    if (!ligthCheckout) return null;
                    ref = "pull-requests/" + prHead.getId() + "/merge";
                }
                return new BitbucketSCMFileSystem(BitbucketApiFactory.newInstance(serverURL, authenticator, owner, null, repository), (String)ref, rev);
            } else {
                if (!(head instanceof BitbucketTagSCMHead)) return null;
                ref = "tags/" + head.getName();
            }
            return new BitbucketSCMFileSystem(BitbucketApiFactory.newInstance(serverURL, authenticator, owner, null, repository), (String)ref, rev);
        }
    }
}

