/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.ServerHeadEvent;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.JsonParser;
import com.cloudbees.jenkins.plugins.bitbucket.server.events.NativeServerPullRequestEvent;
import hudson.RestrictedSince;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.scm.api.SCMEvent;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class NativeServerPullRequestHookProcessor
extends HookProcessor {
    private static final Logger LOGGER = Logger.getLogger(NativeServerPullRequestHookProcessor.class.getName());

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin) {
    }

    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin, String serverUrl) {
        SCMEvent.Type eventType;
        NativeServerPullRequestEvent pullRequestEvent;
        try {
            pullRequestEvent = JsonParser.toJava(payload, NativeServerPullRequestEvent.class);
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Can not read hook payload", e);
            return;
        }
        switch (hookEvent) {
            case SERVER_PULL_REQUEST_OPENED: {
                eventType = SCMEvent.Type.CREATED;
                break;
            }
            case SERVER_PULL_REQUEST_MERGED: 
            case SERVER_PULL_REQUEST_DECLINED: 
            case SERVER_PULL_REQUEST_DELETED: {
                eventType = SCMEvent.Type.REMOVED;
                break;
            }
            case SERVER_PULL_REQUEST_MODIFIED: 
            case SERVER_PULL_REQUEST_REVIEWER_UPDATED: 
            case SERVER_PULL_REQUEST_FROM_REF_UPDATED: {
                eventType = SCMEvent.Type.UPDATED;
                break;
            }
            default: {
                LOGGER.log(Level.INFO, "Unknown hook event {0} received from Bitbucket Server", (Object)hookEvent);
                return;
            }
        }
        this.notifyEvent(new ServerHeadEvent(serverUrl, eventType, pullRequestEvent, origin), BitbucketSCMSource.getEventDelaySeconds());
    }
}

