/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketPullRequestEvent;
import com.cloudbees.jenkins.plugins.bitbucket.client.BitbucketCloudWebhookPayload;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.BitbucketType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookProcessor;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.PREvent;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.BitbucketServerWebhookPayload;
import hudson.RestrictedSince;
import jenkins.scm.api.SCMEvent;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
@RestrictedSince(value="933.3.0")
public class PullRequestHookProcessor
extends HookProcessor {
    @Override
    public void process(HookEventType hookEvent, String payload, BitbucketType instanceType, String origin) {
        BitbucketPullRequestEvent pull;
        if (payload != null && (pull = instanceType == BitbucketType.SERVER ? BitbucketServerWebhookPayload.pullRequestEventFromPayload(payload) : BitbucketCloudWebhookPayload.pullRequestEventFromPayload(payload)) != null) {
            this.notifyEvent(new PREvent(switch (hookEvent) {
                case HookEventType.PULL_REQUEST_CREATED -> SCMEvent.Type.CREATED;
                case HookEventType.PULL_REQUEST_DECLINED, HookEventType.PULL_REQUEST_MERGED -> SCMEvent.Type.REMOVED;
                default -> SCMEvent.Type.UPDATED;
            }, pull, origin, hookEvent), BitbucketSCMSource.getEventDelaySeconds());
        }
    }
}

