/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.jenkins.plugins.bitbucket.hooks;

import com.cloudbees.jenkins.plugins.bitbucket.BitbucketSCMSource;
import com.cloudbees.jenkins.plugins.bitbucket.api.BitbucketWebHook;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.api.endpoint.BitbucketEndpointProvider;
import com.cloudbees.jenkins.plugins.bitbucket.client.repository.BitbucketRepositoryHook;
import com.cloudbees.jenkins.plugins.bitbucket.endpoints.BitbucketServerEndpoint;
import com.cloudbees.jenkins.plugins.bitbucket.hooks.HookEventType;
import com.cloudbees.jenkins.plugins.bitbucket.impl.util.BitbucketApiUtils;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.BitbucketServerWebhook;
import com.cloudbees.jenkins.plugins.bitbucket.server.client.repository.NativeBitbucketServerWebhook;
import com.damnhandy.uri.template.UriTemplate;
import com.google.common.base.Objects;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Util;
import hudson.util.Secret;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;

public class WebhookConfiguration {
    private static final List<String> CLOUD_EVENTS = Collections.unmodifiableList(Arrays.asList(HookEventType.PUSH.getKey(), HookEventType.PULL_REQUEST_CREATED.getKey(), HookEventType.PULL_REQUEST_UPDATED.getKey(), HookEventType.PULL_REQUEST_MERGED.getKey(), HookEventType.PULL_REQUEST_DECLINED.getKey()));
    private static final List<String> NATIVE_SERVER_EVENTS_v7 = Collections.unmodifiableList(Arrays.asList(HookEventType.SERVER_REFS_CHANGED.getKey(), HookEventType.SERVER_PULL_REQUEST_OPENED.getKey(), HookEventType.SERVER_PULL_REQUEST_MERGED.getKey(), HookEventType.SERVER_PULL_REQUEST_DECLINED.getKey(), HookEventType.SERVER_PULL_REQUEST_DELETED.getKey(), HookEventType.SERVER_PULL_REQUEST_MODIFIED.getKey(), HookEventType.SERVER_PULL_REQUEST_REVIEWER_UPDATED.getKey(), HookEventType.SERVER_MIRROR_REPO_SYNCHRONIZED.getKey(), HookEventType.SERVER_PULL_REQUEST_FROM_REF_UPDATED.getKey()));
    private static final List<String> NATIVE_SERVER_EVENTS_v6_5 = Collections.unmodifiableList(NATIVE_SERVER_EVENTS_v7.subList(0, 8));
    private static final List<String> NATIVE_SERVER_EVENTS_v6 = Collections.unmodifiableList(NATIVE_SERVER_EVENTS_v7.subList(0, 7));
    private static final List<String> NATIVE_SERVER_EVENTS_v5 = Collections.unmodifiableList(NATIVE_SERVER_EVENTS_v7.subList(0, 5));
    private static final String description = "Jenkins hook";
    private final String committersToIgnore;

    public WebhookConfiguration() {
        this.committersToIgnore = null;
    }

    public WebhookConfiguration(@CheckForNull String committersToIgnore) {
        this.committersToIgnore = committersToIgnore;
    }

    public String getCommittersToIgnore() {
        return this.committersToIgnore;
    }

    boolean updateHook(BitbucketWebHook hook, BitbucketSCMSource owner) {
        boolean updated = false;
        String signatureSecret = this.getSecret(owner.getServerUrl());
        if (hook instanceof BitbucketRepositoryHook) {
            BitbucketRepositoryHook cloudHook = (BitbucketRepositoryHook)hook;
            if (!hook.getEvents().containsAll(CLOUD_EVENTS)) {
                TreeSet<String> events = new TreeSet<String>(hook.getEvents());
                events.addAll(CLOUD_EVENTS);
                cloudHook.setEvents(new ArrayList<String>(events));
                updated = true;
            }
            if (!Objects.equal((Object)hook.getSecret(), (Object)signatureSecret)) {
                cloudHook.setSecret(signatureSecret);
                updated = true;
            }
        } else if (hook instanceof BitbucketServerWebhook) {
            BitbucketServerWebhook serverHook = (BitbucketServerWebhook)hook;
            String hookCommittersToIgnore = Util.fixEmptyAndTrim((String)serverHook.getCommittersToIgnore());
            String thisCommittersToIgnore = Util.fixEmptyAndTrim((String)this.committersToIgnore);
            if (!Objects.equal((Object)thisCommittersToIgnore, (Object)hookCommittersToIgnore)) {
                serverHook.setCommittersToIgnore(thisCommittersToIgnore);
                updated = true;
            }
            if (!Objects.equal((Object)serverHook.getSecret(), (Object)signatureSecret)) {
                serverHook.setSecret(signatureSecret);
                updated = true;
            }
        } else if (hook instanceof NativeBitbucketServerWebhook) {
            List<String> events;
            NativeBitbucketServerWebhook serverHook = (NativeBitbucketServerWebhook)hook;
            String serverURL = owner.getServerUrl();
            String url = WebhookConfiguration.getNativeServerWebhookUrl(serverURL, owner.getEndpointJenkinsRootURL());
            if (!url.equals(serverHook.getUrl())) {
                serverHook.setUrl(url);
                updated = true;
            }
            if ((events = serverHook.getEvents()) == null) {
                serverHook.setEvents(WebhookConfiguration.getNativeServerEvents(serverURL));
                updated = true;
            } else if (!events.containsAll(WebhookConfiguration.getNativeServerEvents(serverURL))) {
                TreeSet<String> newEvents = new TreeSet<String>(events);
                newEvents.addAll(WebhookConfiguration.getNativeServerEvents(serverURL));
                serverHook.setEvents(new ArrayList<String>(newEvents));
                updated = true;
            }
            if (!Objects.equal((Object)serverHook.getSecret(), (Object)signatureSecret)) {
                serverHook.setSecret(signatureSecret);
                updated = true;
            }
        }
        return updated;
    }

    public BitbucketWebHook getHook(BitbucketSCMSource owner) {
        String serverUrl = owner.getServerUrl();
        String rootUrl = owner.getEndpointJenkinsRootURL();
        String signatureSecret = this.getSecret(owner.getServerUrl());
        if (BitbucketApiUtils.isCloud(serverUrl)) {
            BitbucketRepositoryHook hook = new BitbucketRepositoryHook();
            hook.setEvents(CLOUD_EVENTS);
            hook.setActive(true);
            hook.setDescription(description);
            hook.setUrl(rootUrl + "bitbucket-scmsource-hook/notify");
            hook.setSecret(signatureSecret);
            return hook;
        }
        switch (BitbucketServerEndpoint.findWebhookImplementation(serverUrl)) {
            case NATIVE: {
                NativeBitbucketServerWebhook hook = new NativeBitbucketServerWebhook();
                hook.setActive(true);
                hook.setDescription(description);
                hook.setEvents(WebhookConfiguration.getNativeServerEvents(serverUrl));
                hook.setUrl(WebhookConfiguration.getNativeServerWebhookUrl(serverUrl, rootUrl));
                hook.setSecret(signatureSecret);
                return hook;
            }
        }
        BitbucketServerWebhook hook = new BitbucketServerWebhook();
        hook.setActive(true);
        hook.setDescription(description);
        hook.setUrl(rootUrl + "bitbucket-scmsource-hook/notify");
        hook.setCommittersToIgnore(this.committersToIgnore);
        hook.setSecret(signatureSecret);
        return hook;
    }

    @Nullable
    private String getSecret(@NonNull String serverURL) {
        BitbucketEndpoint endpoint = (BitbucketEndpoint)BitbucketEndpointProvider.lookupEndpoint(serverURL).orElseThrow();
        if (endpoint.isEnableHookSignature()) {
            StringCredentials credentials = endpoint.hookSignatureCredentials();
            if (credentials != null) {
                return Secret.toString((Secret)credentials.getSecret());
            }
            throw new IllegalStateException("Credentials " + endpoint.getHookSignatureCredentialsId() + " not found on hook registration");
        }
        return null;
    }

    private static List<String> getNativeServerEvents(String serverUrl) {
        BitbucketServerEndpoint endpoint = BitbucketEndpointProvider.lookupEndpoint(serverUrl, BitbucketServerEndpoint.class).orElse(null);
        if (endpoint != null) {
            switch (endpoint.getServerVersion()) {
                case VERSION_5: {
                    return NATIVE_SERVER_EVENTS_v5;
                }
                case VERSION_5_10: {
                    return NATIVE_SERVER_EVENTS_v6;
                }
                case VERSION_6: {
                    return NATIVE_SERVER_EVENTS_v6;
                }
                case VERSION_6_5: {
                    return NATIVE_SERVER_EVENTS_v6_5;
                }
            }
            return NATIVE_SERVER_EVENTS_v7;
        }
        return NATIVE_SERVER_EVENTS_v7;
    }

    private static String getNativeServerWebhookUrl(String serverUrl, String rootUrl) {
        return UriTemplate.buildFromTemplate((String)rootUrl).template(new String[]{"bitbucket-scmsource-hook/notify"}).query(new String[]{"server_url"}).build().set("server_url", (Object)serverUrl).expand();
    }
}

