/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.computed;

import com.cloudbees.hudson.plugins.folder.computed.ComputedFolder;
import com.cloudbees.hudson.plugins.folder.computed.FolderComputation;
import com.cloudbees.hudson.plugins.folder.computed.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import hudson.Extension;
import hudson.model.Computer;
import hudson.model.Executor;
import hudson.model.Node;
import hudson.model.Queue;
import hudson.model.queue.CauseOfBlockage;
import hudson.model.queue.QueueTaskDispatcher;
import jenkins.model.Jenkins;
import org.jvnet.localizer.Localizable;

@Extension
public class ThrottleComputationQueueTaskDispatcher
extends QueueTaskDispatcher {
    public CauseOfBlockage canRun(Queue.Item item) {
        if (item.task instanceof ComputedFolder && this.indexingCount() > 5) {
            return CauseOfBlockage.fromMessage((Localizable)Messages._ThrottleComputationQueueTaskDispatcher_MaxConcurrentIndexing());
        }
        return null;
    }

    public int indexingCount() {
        Jenkins j = Jenkins.getInstance();
        if (j == null) {
            return 0;
        }
        int result = this.indexingCount((Node)j);
        for (Node n : j.getNodes()) {
            result += this.indexingCount(n);
        }
        return result;
    }

    public int indexingCount(@CheckForNull Node node) {
        Computer computer;
        int result = 0;
        Computer computer2 = computer = node == null ? null : node.toComputer();
        if (computer != null) {
            for (Executor e : computer.getExecutors()) {
                if (!(e.getCurrentExecutable() instanceof FolderComputation)) continue;
                ++result;
            }
            for (Executor e : computer.getOneOffExecutors()) {
                if (!(e.getCurrentExecutable() instanceof FolderComputation)) continue;
                ++result;
            }
        }
        return result;
    }
}

