/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.hudson.plugins.folder.health;

import com.cloudbees.hudson.plugins.folder.Folder;
import hudson.model.AbstractDescribableImpl;
import hudson.model.HealthReport;
import hudson.model.Item;
import hudson.model.Job;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;

public abstract class FolderHealthMetric
extends AbstractDescribableImpl<FolderHealthMetric> {
    public Type getType() {
        return Type.RECURSIVE_ALL_ITEMS;
    }

    public abstract Reporter reporter();

    public static HealthReport getHealthReport(Item item) {
        if (item instanceof Job) {
            return ((Job)item).getBuildHealth();
        }
        if (item instanceof Folder) {
            return ((Folder)item).getBuildHealth();
        }
        try {
            Method getBuildHealth = item.getClass().getMethod("getBuildHealth", new Class[0]);
            return (HealthReport)getBuildHealth.invoke((Object)item, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            return null;
        }
    }

    public static enum Type {
        IMMEDIATE_TOP_LEVEL_ITEMS(false, true),
        RECURSIVE_TOP_LEVEL_ITEMS(true, true),
        IMMEDIATE_ALL_ITEMS(false, false),
        RECURSIVE_ALL_ITEMS(true, false);

        private final boolean recursive;
        private final boolean topLevelItems;

        private Type(boolean recursive, boolean topLevelItems) {
            this.recursive = recursive;
            this.topLevelItems = topLevelItems;
        }

        public boolean isRecursive() {
            return this.recursive;
        }

        public boolean isTopLevelItems() {
            return this.topLevelItems;
        }
    }

    public static interface Reporter {
        public void observe(Item var1);

        public List<HealthReport> report();
    }
}

