/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.custom.security;

import com.cloudbees.jenkins.plugins.sshcredentials.SSHUserPrivateKey;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.configfiles.custom.security.CustomizedCredentialMapping;
import org.jenkinsci.plugins.configfiles.custom.security.TokenKeyRequirement;
import org.jenkinsci.plugins.configfiles.custom.security.TokenValueMacro;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.jenkinsci.plugins.tokenmacro.MacroEvaluationException;

public class CustomConfigCredentialsHelper {
    private static final Logger LOGGER = Logger.getLogger(CustomConfigCredentialsHelper.class.getName());

    private CustomConfigCredentialsHelper() {
    }

    public static Map<String, IdCredentials> resolveCredentials(Run<?, ?> build, List<CustomizedCredentialMapping> customizedCredentialMappings, TaskListener listener) {
        HashMap<String, IdCredentials> customizedCredentialsMap = new HashMap<String, IdCredentials>();
        for (CustomizedCredentialMapping customizedCredentialMapping : customizedCredentialMappings) {
            IdCredentials c;
            String credentialsId = customizedCredentialMapping.getCredentialsId();
            String tokenKey = customizedCredentialMapping.getTokenKey();
            List<Object> domainRequirements = Collections.emptyList();
            if (tokenKey != null && !tokenKey.isBlank()) {
                domainRequirements = Collections.singletonList(new TokenKeyRequirement(tokenKey));
            }
            if ((c = CredentialsProvider.findCredentialById((String)credentialsId, IdCredentials.class, build, domainRequirements)) != null) {
                customizedCredentialsMap.put(tokenKey, c);
                continue;
            }
            listener.getLogger().println("Could not find credentials [" + credentialsId + "] for " + String.valueOf(build));
        }
        return customizedCredentialsMap;
    }

    @NonNull
    public static List<String> secretsForMasking(Run<?, ?> build, List<CustomizedCredentialMapping> customizedCredentialMappings) {
        ArrayList<String> sensitiveStrings = new ArrayList<String>();
        Map<String, IdCredentials> resolveCredentials = CustomConfigCredentialsHelper.resolveCredentials(build, customizedCredentialMappings, TaskListener.NULL);
        for (IdCredentials credential : resolveCredentials.values()) {
            if (credential instanceof StandardUsernamePasswordCredentials) {
                StandardUsernamePasswordCredentials supc = (StandardUsernamePasswordCredentials)credential;
                if (supc.isUsernameSecret()) {
                    sensitiveStrings.add(supc.getUsername());
                }
                sensitiveStrings.add(supc.getPassword().getPlainText());
                continue;
            }
            if (credential instanceof SSHUserPrivateKey) {
                SSHUserPrivateKey sshUserPrivateKey = (SSHUserPrivateKey)credential;
                if (sshUserPrivateKey.isUsernameSecret()) {
                    sensitiveStrings.add(sshUserPrivateKey.getUsername());
                }
                List privateKeys = sshUserPrivateKey.getPrivateKeys();
                if (sshUserPrivateKey.getPrivateKeys().isEmpty()) continue;
                sensitiveStrings.add((String)privateKeys.get(0));
                continue;
            }
            if (!(credential instanceof StringCredentials)) continue;
            sensitiveStrings.add(((StringCredentials)credential).getSecret().getPlainText());
        }
        return sensitiveStrings;
    }

    public static String fillAuthentication(Run<?, ?> build, FilePath workDir, TaskListener listener, String customizedContent, Map<String, IdCredentials> customizedCredentialsMap) throws MacroEvaluationException, IOException, InterruptedException {
        ArrayList customizedMacroArray = new ArrayList();
        customizedCredentialsMap.forEach((key, value) -> customizedMacroArray.addAll(CustomConfigCredentialsHelper.createCredentialBasedToken(key, value)));
        ArrayList tokenMacroArray = customizedMacroArray;
        return TokenValueMacro.expand(build, (FilePath)workDir, (TaskListener)listener, (String)customizedContent, (boolean)false, tokenMacroArray);
    }

    private static List<TokenValueMacro> createCredentialBasedToken(String tokenKey, IdCredentials credential) {
        ArrayList<TokenValueMacro> credentialTokens = new ArrayList<TokenValueMacro>();
        Object tokenValue = "";
        if (credential instanceof StandardUsernamePasswordCredentials) {
            StandardUsernamePasswordCredentials usernamePasswordCredentials = (StandardUsernamePasswordCredentials)credential;
            tokenValue = usernamePasswordCredentials.getPassword().getPlainText();
            String tokenUser = usernamePasswordCredentials.getUsername();
            credentialTokens.add(new TokenValueMacro(tokenKey + "_USR", tokenUser));
            credentialTokens.add(new TokenValueMacro(tokenKey + "_PSW", (String)tokenValue));
            tokenValue = tokenUser + ":" + (String)tokenValue;
        } else if (credential instanceof SSHUserPrivateKey) {
            SSHUserPrivateKey sshUserPrivateKey = (SSHUserPrivateKey)credential;
            String tokenUser = sshUserPrivateKey.getUsername();
            credentialTokens.add(new TokenValueMacro(tokenKey + "_USR", tokenUser));
            List privateKeys = sshUserPrivateKey.getPrivateKeys();
            if (privateKeys.isEmpty()) {
                LOGGER.log(Level.WARNING, "Property {0}: not private key defined in {1}, skip", new Object[]{tokenKey, sshUserPrivateKey.getId()});
            } else if (privateKeys.size() == 1) {
                LOGGER.log(Level.FINE, "Property {0}: use {1}", new Object[]{tokenKey, sshUserPrivateKey.getId()});
                tokenValue = (String)privateKeys.get(0);
            } else {
                LOGGER.log(Level.WARNING, "Property {0}: more than ({1}) private key defined in {1}, use first private key", new Object[]{tokenKey, privateKeys.size(), sshUserPrivateKey.getId()});
                tokenValue = (String)privateKeys.get(0);
            }
        } else if (credential instanceof StringCredentials) {
            StringCredentials stringCredentials = (StringCredentials)credential;
            tokenValue = stringCredentials.getSecret().getPlainText();
        }
        credentialTokens.add(new TokenValueMacro(tokenKey, (String)tokenValue));
        return credentialTokens;
    }
}

