/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.custom.security;

import com.cloudbees.plugins.credentials.CredentialsMatchers;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.common.StandardListBoxModel;
import com.cloudbees.plugins.credentials.common.StandardUsernameCredentials;
import hudson.Extension;
import hudson.model.AbstractDescribableImpl;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Queue;
import hudson.model.queue.Tasks;
import hudson.security.ACL;
import hudson.util.ListBoxModel;
import java.io.Serializable;
import java.util.Collections;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.plaincredentials.StringCredentials;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class CustomizedCredentialMapping
extends AbstractDescribableImpl<CustomizedCredentialMapping>
implements Serializable {
    private final String tokenKey;
    private final String credentialsId;

    @DataBoundConstructor
    public CustomizedCredentialMapping(String tokenKey, String credentialsId) {
        this.tokenKey = tokenKey;
        this.credentialsId = credentialsId;
    }

    public String getTokenKey() {
        return this.tokenKey;
    }

    public String getCredentialsId() {
        return this.credentialsId;
    }

    @Extension
    public static class DescriptorImpl
    extends Descriptor<CustomizedCredentialMapping> {
        public ListBoxModel doFillCredentialsIdItems(@AncestorInPath Item item, @QueryParameter String credentialsId) {
            StandardListBoxModel result = new StandardListBoxModel();
            if (item == null) {
                if (!Jenkins.get().hasPermission(Jenkins.MANAGE)) {
                    return result.includeCurrentValue(credentialsId);
                }
                return result.includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernameCredentials.class)).includeMatchingAs(ACL.SYSTEM, (ItemGroup)Jenkins.get(), StringCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StringCredentials.class)).includeCurrentValue(credentialsId);
            }
            if (!item.hasPermission(Item.EXTENDED_READ) && !item.hasPermission(CredentialsProvider.USE_ITEM)) {
                return result.includeCurrentValue(credentialsId);
            }
            return result.includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, StandardUsernameCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StandardUsernameCredentials.class)).includeMatchingAs(item instanceof Queue.Task ? Tasks.getAuthenticationOf((Queue.Task)((Queue.Task)item)) : ACL.SYSTEM, item, StringCredentials.class, Collections.emptyList(), CredentialsMatchers.instanceOf(StringCredentials.class)).includeCurrentValue(credentialsId);
        }
    }
}

