/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.configfiles.maven.job;

import hudson.Extension;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.FreeStyleBuild;
import hudson.model.Run;
import hudson.util.Secret;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.apache.commons.beanutils.PropertyUtils;
import org.jenkinsci.plugins.configfiles.maven.job.MvnGlobalSettingsProvider;
import org.jenkinsci.plugins.configfiles.maven.job.MvnSettingsProvider;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;

@Extension
public class MvnConsoleLogFilter
extends ConsoleLogFilter {
    private static final Logger LOGGER = Logger.getLogger(MvnConsoleLogFilter.class.getName());

    public OutputStream decorateLogger(Run build, OutputStream logger) throws IOException, InterruptedException {
        AbstractProject parent;
        if (build instanceof AbstractBuild && !(build instanceof FreeStyleBuild) && (parent = (AbstractProject)build.getParent()).getClass().getSimpleName().equals("MavenModuleSet")) {
            ArrayList<String> secretValues;
            block6: {
                secretValues = new ArrayList<String>();
                try {
                    Object globalSettings;
                    Object settings = PropertyUtils.getProperty((Object)parent, (String)"settings");
                    if (settings instanceof MvnSettingsProvider) {
                        MvnSettingsProvider provider = (MvnSettingsProvider)((Object)settings);
                        secretValues.addAll(provider.getSensitiveContentForMasking((AbstractBuild)build));
                    }
                    if ((globalSettings = PropertyUtils.getProperty((Object)parent, (String)"globalSettings")) instanceof MvnGlobalSettingsProvider) {
                        MvnGlobalSettingsProvider provider = (MvnGlobalSettingsProvider)((Object)globalSettings);
                        secretValues.addAll(provider.getSensitiveContentForMasking((AbstractBuild)build));
                    }
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    LOGGER.log(Level.WARNING, "Unable to mask secrets for " + parent.getFullName() + "#" + build.getNumber(), e);
                    PrintStream ps = new PrintStream(logger, false, build.getCharset());
                    e.printStackTrace(ps);
                    ps.flush();
                    if ($assertionsDisabled) break block6;
                    throw new AssertionError((Object)"MavenModuleSet API has changed in an incompatable way");
                }
            }
            if (!secretValues.isEmpty()) {
                Secret pattern = Secret.fromString((String)SecretPatterns.getAggregateSecretPattern(secretValues).pattern());
                return new SecretPatterns.MaskingOutputStream(logger, () -> Pattern.compile(pattern.getPlainText()), build.getCharset().name());
            }
        }
        return logger;
    }
}

