/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.credentialsbinding.impl;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.console.ConsoleLogFilter;
import hudson.model.AbstractBuild;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.Secret;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.codec.Charsets;
import org.jenkinsci.plugins.credentialsbinding.MultiBinding;
import org.jenkinsci.plugins.credentialsbinding.masking.SecretPatterns;
import org.jenkinsci.plugins.workflow.steps.AbstractStepExecutionImpl;
import org.jenkinsci.plugins.workflow.steps.BodyExecutionCallback;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.GeneralNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.MissingContextVariableException;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public final class BindingStep
extends Step {
    private final List<MultiBinding> bindings;

    @DataBoundConstructor
    public BindingStep(List<MultiBinding> bindings) {
        this.bindings = bindings;
    }

    public List<MultiBinding> getBindings() {
        return this.bindings;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution2(this, context);
    }

    @Extension
    public static final class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withCredentials";
        }

        public String getDisplayName() {
            return "Bind credentials to variables";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return Collections.unmodifiableSet(new HashSet<Class>(Arrays.asList(TaskListener.class, Run.class)));
        }
    }

    private static final class Callback
    extends BodyExecutionCallback.TailCall {
        private static final long serialVersionUID = 1L;
        private final List<MultiBinding.Unbinder> unbinders;

        Callback(List<MultiBinding.Unbinder> unbinders) {
            this.unbinders = unbinders;
        }

        protected void finished(StepContext context) throws Exception {
            Exception xx = null;
            for (MultiBinding.Unbinder unbinder : this.unbinders) {
                try {
                    unbinder.unbind((Run)context.get(Run.class), (FilePath)context.get(FilePath.class), (Launcher)context.get(Launcher.class), (TaskListener)context.get(TaskListener.class));
                }
                catch (Exception x) {
                    if (xx == null) {
                        xx = x;
                        continue;
                    }
                    xx.addSuppressed(x);
                }
            }
            if (xx != null) {
                throw xx;
            }
        }
    }

    private static final class Filter
    extends ConsoleLogFilter
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Secret pattern;
        private String charsetName;

        Filter(Collection<String> secrets, String charsetName) {
            this.pattern = Secret.fromString((String)SecretPatterns.getAggregateSecretPattern(secrets).pattern());
            this.charsetName = charsetName;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.charsetName == null) {
                this.charsetName = Charsets.UTF_8.name();
            }
            return this;
        }

        public OutputStream decorateLogger(AbstractBuild _ignore, OutputStream logger) throws IOException, InterruptedException {
            return new SecretPatterns.MaskingOutputStream(logger, () -> Pattern.compile(this.pattern.getPlainText()), this.charsetName);
        }
    }

    private static final class Overrider
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final Map<String, Secret> overrides = new HashMap<String, Secret>();
        private Map<String, String> publicOverrides;

        Overrider(Map<String, String> overrides, Map<String, String> publicOverrides) {
            for (Map.Entry<String, String> override : overrides.entrySet()) {
                this.overrides.put(override.getKey(), Secret.fromString((String)override.getValue()));
            }
            this.publicOverrides = publicOverrides;
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            for (Map.Entry<String, Secret> entry : this.overrides.entrySet()) {
                env.override(entry.getKey(), entry.getValue().getPlainText());
            }
            for (Map.Entry<String, Object> entry : this.publicOverrides.entrySet()) {
                env.override(entry.getKey(), (String)entry.getValue());
            }
        }

        public Set<String> getSensitiveVariables() {
            return Collections.unmodifiableSet(this.overrides.keySet());
        }

        private Object readResolve() {
            if (this.publicOverrides == null) {
                this.publicOverrides = new HashMap<String, String>();
            }
            return this;
        }
    }

    private static final class Execution2
    extends GeneralNonBlockingStepExecution {
        private static final long serialVersionUID = 1L;
        private transient BindingStep step;

        Execution2(@Nonnull BindingStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        public boolean start() throws Exception {
            this.run(this::doStart);
            return false;
        }

        private void doStart() throws Exception {
            Run run = (Run)this.getContext().get(Run.class);
            TaskListener listener = (TaskListener)this.getContext().get(TaskListener.class);
            FilePath workspace = (FilePath)this.getContext().get(FilePath.class);
            Launcher launcher = (Launcher)this.getContext().get(Launcher.class);
            LinkedHashMap<String, String> secretOverrides = new LinkedHashMap<String, String>();
            LinkedHashMap<String, String> publicOverrides = new LinkedHashMap<String, String>();
            ArrayList<MultiBinding.Unbinder> unbinders = new ArrayList<MultiBinding.Unbinder>();
            for (MultiBinding binding : this.step.bindings) {
                if (binding.getDescriptor().requiresWorkspace() && (workspace == null || launcher == null)) {
                    throw new MissingContextVariableException(FilePath.class);
                }
                MultiBinding.MultiEnvironment environment = binding.bind(run, workspace, launcher, listener);
                unbinders.add(environment.getUnbinder());
                secretOverrides.putAll(environment.getSecretValues());
                publicOverrides.putAll(environment.getPublicValues());
            }
            if (!secretOverrides.isEmpty()) {
                boolean unix = launcher != null ? launcher.isUnix() : true;
                listener.getLogger().println("Masking supported pattern matches of " + secretOverrides.keySet().stream().map(v -> unix ? "$" + v : "%" + v + "%").collect(Collectors.joining(" or ")));
            }
            this.getContext().newBodyInvoker().withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new Overrider(secretOverrides, publicOverrides))).withContext((Object)BodyInvoker.mergeConsoleLogFilters((ConsoleLogFilter)((ConsoleLogFilter)this.getContext().get(ConsoleLogFilter.class)), (ConsoleLogFilter)new Filter(secretOverrides.values(), run.getCharset().name()))).withCallback((BodyExecutionCallback)new Callback2(unbinders)).start();
        }

        private final class Callback2
        extends GeneralNonBlockingStepExecution.TailCall {
            private static final long serialVersionUID = 1L;
            private final List<MultiBinding.Unbinder> unbinders;

            Callback2(List<MultiBinding.Unbinder> unbinders) {
                super((GeneralNonBlockingStepExecution)Execution2.this);
                this.unbinders = unbinders;
            }

            protected void finished(StepContext context) throws Exception {
                new Callback(this.unbinders).finished(context);
            }
        }
    }

    @Deprecated
    private static final class Execution
    extends AbstractStepExecutionImpl {
        private static final long serialVersionUID = 1L;

        private Execution() {
        }

        public boolean start() throws Exception {
            throw new AssertionError();
        }
    }
}

