/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.domains;

import com.cloudbees.plugins.credentials.domains.DomainRequirement;
import com.cloudbees.plugins.credentials.domains.DomainSpecification;
import com.cloudbees.plugins.credentials.domains.DomainSpecificationDescriptor;
import com.cloudbees.plugins.credentials.domains.HostnamePortRequirement;
import com.cloudbees.plugins.credentials.domains.HostnameRequirement;
import com.cloudbees.plugins.credentials.domains.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.kohsuke.stapler.DataBoundConstructor;

public class HostnamePortSpecification
extends DomainSpecification {
    @CheckForNull
    private final String includes;
    @CheckForNull
    private final String excludes;

    @DataBoundConstructor
    public HostnamePortSpecification(@CheckForNull String includes, @CheckForNull String excludes) {
        this.includes = includes;
        this.excludes = excludes;
    }

    @CheckForNull
    public String getIncludes() {
        return this.includes;
    }

    @CheckForNull
    public String getExcludes() {
        return this.excludes;
    }

    @NonNull
    public DomainSpecification.Result test(@NonNull DomainRequirement requirement) {
        if (requirement instanceof HostnamePortRequirement) {
            String hostPort = ((HostnamePortRequirement)requirement).getHostname() + ":" + ((HostnamePortRequirement)requirement).getPort();
            if (this.includes != null) {
                boolean isInclude = false;
                for (String include : this.includes.split("[,\\n ]")) {
                    if ((include = Util.fixEmptyAndTrim((String)include)) == null) continue;
                    if (include.indexOf(58) == -1) {
                        include = include + ":*";
                    }
                    if (!FilenameUtils.wildcardMatch((String)hostPort, (String)include, (IOCase)IOCase.INSENSITIVE)) continue;
                    isInclude = true;
                    break;
                }
                if (!isInclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            if (this.excludes != null) {
                boolean isExclude = false;
                for (String exclude : this.excludes.split("[,\\n ]")) {
                    if ((exclude = Util.fixEmptyAndTrim((String)exclude)) == null) continue;
                    if (exclude.indexOf(58) == -1) {
                        exclude = exclude + ":*";
                    }
                    if (!FilenameUtils.wildcardMatch((String)hostPort, (String)exclude, (IOCase)IOCase.INSENSITIVE)) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
        } else if (requirement instanceof HostnameRequirement) {
            int index;
            String hostname = ((HostnameRequirement)requirement).getHostname();
            if (this.includes != null) {
                boolean isInclude = false;
                for (String include : this.includes.split("[,\\n ]")) {
                    if ((include = Util.fixEmptyAndTrim((String)include)) == null) continue;
                    index = include.indexOf(":");
                    if (index != -1) {
                        include = include.substring(0, index);
                    }
                    if (!FilenameUtils.wildcardMatch((String)hostname, (String)include, (IOCase)IOCase.INSENSITIVE)) continue;
                    isInclude = true;
                    break;
                }
                if (!isInclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
            if (this.excludes != null) {
                boolean isExclude = false;
                for (String exclude : this.excludes.split("[,\\n ]")) {
                    if ((exclude = Util.fixEmptyAndTrim((String)exclude)) == null) continue;
                    index = exclude.indexOf(":");
                    if (index != -1) {
                        exclude = exclude.substring(0, index);
                    }
                    if (!FilenameUtils.wildcardMatch((String)hostname, (String)exclude, (IOCase)IOCase.INSENSITIVE)) continue;
                    isExclude = true;
                    break;
                }
                if (isExclude) {
                    return DomainSpecification.Result.NEGATIVE;
                }
            }
        }
        return DomainSpecification.Result.UNKNOWN;
    }

    @Extension
    public static class DescriptorImpl
    extends DomainSpecificationDescriptor {
        public String getDisplayName() {
            return Messages.HostnamePortSpecification_DisplayName();
        }
    }
}

