/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsNameProvider;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import com.cloudbees.plugins.credentials.common.IdCredentials;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Extension;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.kohsuke.args4j.Argument;

@Extension
public class ListCredentialsCommand
extends BaseCredentialsCLICommand {
    @Argument(metaVar="STORE", usage="Store ID", required=true)
    public CredentialsStore store;

    public String getShortDescription() {
        return Messages.ListCredentialsCommand_ShortDescription();
    }

    protected int run() throws Exception {
        this.store.checkPermission(CredentialsProvider.VIEW);
        List<Domain> domains = this.store.getDomains();
        for (Domain domain : domains) {
            List<Credentials> credentials = this.store.getCredentials(domain);
            LinkedHashMap<Object, String> nameById = new LinkedHashMap<Object, String>(credentials.size());
            int maxIdLen = "# of Credentials".length();
            int maxNameLen = 0;
            int index = 0;
            for (Credentials credentials2 : credentials) {
                Object id;
                if (credentials2 instanceof IdCredentials) {
                    id = ((IdCredentials)credentials2).getId();
                } else {
                    while (nameById.containsKey("index-" + index)) {
                        ++index;
                    }
                    id = "index-" + index;
                    ++index;
                }
                String name = CredentialsNameProvider.name(credentials2);
                nameById.put(id, name);
                maxIdLen = Math.max(maxIdLen, ((String)id).length());
                maxNameLen = Math.max(maxNameLen, name.length());
            }
            this.stdout.println(StringUtils.repeat((String)"=", (int)(maxIdLen + maxNameLen + 1)));
            this.stdout.println(StringUtils.rightPad((String)"Domain", (int)maxIdLen) + " " + (domain.isGlobal() ? "(global)" : domain.getName()));
            this.stdout.println(StringUtils.rightPad((String)"Description", (int)maxIdLen) + " " + StringUtils.defaultString((String)domain.getDescription()));
            this.stdout.println(StringUtils.rightPad((String)"# of Credentials", (int)maxIdLen) + " " + credentials.size());
            this.stdout.println(StringUtils.repeat((String)"=", (int)(maxIdLen + maxNameLen + 1)));
            this.stdout.println(StringUtils.rightPad((String)"Id", (int)maxIdLen) + " Name");
            this.stdout.println(StringUtils.repeat((String)"=", (int)maxIdLen) + " " + StringUtils.repeat((String)"=", (int)maxNameLen));
            for (Map.Entry entry : nameById.entrySet()) {
                this.stdout.println(StringUtils.rightPad((String)((String)entry.getKey()), (int)maxIdLen) + " " + (String)entry.getValue());
            }
            this.stdout.println(StringUtils.repeat((String)"=", (int)(maxIdLen + maxNameLen + 1)));
            this.stdout.println();
        }
        return 0;
    }
}

