/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.impl;

import com.cloudbees.plugins.credentials.CredentialsScope;
import com.cloudbees.plugins.credentials.common.StandardUsernamePasswordCredentials;
import com.cloudbees.plugins.credentials.impl.BaseStandardCredentials;
import com.cloudbees.plugins.credentials.impl.Messages;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.util.FormValidation;
import hudson.util.Secret;
import jenkins.security.FIPS140;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class UsernamePasswordCredentialsImpl
extends BaseStandardCredentials
implements StandardUsernamePasswordCredentials {
    @NonNull
    private final String username;
    @NonNull
    private final Secret password;
    @Nullable
    private Boolean usernameSecret = false;

    @DataBoundConstructor
    public UsernamePasswordCredentialsImpl(@CheckForNull CredentialsScope scope, @CheckForNull String id, @CheckForNull String description, @CheckForNull String username, @CheckForNull String password) throws Descriptor.FormException {
        super(scope, id, description);
        this.username = Util.fixNull((String)username);
        if (FIPS140.useCompliantAlgorithms() && StringUtils.length((String)password) < 14) {
            throw new Descriptor.FormException(Messages.passwordTooShortFIPS(), "password");
        }
        this.password = Secret.fromString((String)password);
    }

    @Override
    @NonNull
    public Secret getPassword() {
        return this.password;
    }

    @Override
    @NonNull
    public String getUsername() {
        return this.username;
    }

    @Override
    public boolean isUsernameSecret() {
        return this.usernameSecret != null ? this.usernameSecret : true;
    }

    @DataBoundSetter
    public void setUsernameSecret(boolean usernameSecret) {
        this.usernameSecret = usernameSecret;
    }

    @Extension(ordinal=1.0)
    @Symbol(value={"usernamePassword"})
    public static class DescriptorImpl
    extends BaseStandardCredentials.BaseStandardCredentialsDescriptor {
        @NonNull
        public String getDisplayName() {
            return Messages.UsernamePasswordCredentialsImpl_DisplayName();
        }

        @Override
        public String getIconClassName() {
            return "symbol-id-card";
        }

        @RequirePOST
        public FormValidation doCheckPassword(@QueryParameter String password) {
            if (FIPS140.useCompliantAlgorithms() && StringUtils.length((String)password) < 14) {
                return FormValidation.error((String)Messages.passwordTooShortFIPS());
            }
            return FormValidation.ok();
        }

        @RequirePOST
        public FormValidation doCheckUsername(@QueryParameter String value, @QueryParameter boolean usernameSecret) {
            if (value.isEmpty()) {
                if (usernameSecret) {
                    return FormValidation.warning((String)Messages.UsernamePasswordCredentialsImpl_a_blank_username_cannot_logically_be_con());
                }
                return FormValidation.ok((String)Messages.UsernamePasswordCredentialsImpl_blank_username_did_you_mean_to_use_secre());
            }
            return FormValidation.ok();
        }
    }
}

