/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.matchers;

import com.cloudbees.plugins.credentials.Credentials;
import com.cloudbees.plugins.credentials.CredentialsMatcher;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AnyOfMatcher
implements CredentialsMatcher,
CredentialsMatcher.CQL {
    private static final long serialVersionUID = 8214348092732916263L;
    @NonNull
    private final List<CredentialsMatcher> matchers;

    public AnyOfMatcher(@CheckForNull List<CredentialsMatcher> matchers) {
        this.matchers = new ArrayList(matchers == null ? Collections.emptyList() : matchers);
    }

    @Override
    public boolean matches(@NonNull Credentials item) {
        return this.matchers.stream().anyMatch(matcher -> matcher.matches(item));
    }

    @Override
    @CheckForNull
    public String describe() {
        if (this.matchers.isEmpty()) {
            return "true";
        }
        StringBuilder sb = new StringBuilder("(");
        boolean first = true;
        for (CredentialsMatcher m : this.matchers) {
            String description;
            String string = description = m instanceof CredentialsMatcher.CQL ? ((CredentialsMatcher.CQL)m).describe() : null;
            if (description == null) {
                return null;
            }
            if (first) {
                first = false;
            } else {
                sb.append(" || ");
            }
            sb.append(description);
        }
        sb.append(")");
        return sb.toString();
    }

    public int hashCode() {
        return this.matchers.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AnyOfMatcher that = (AnyOfMatcher)o;
        return this.matchers.equals(that.matchers);
    }

    public String toString() {
        return "AnyMatcher{matchers=" + String.valueOf(this.matchers) + "}";
    }
}

