/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials;

import com.cloudbees.plugins.credentials.CredentialsDescriptor;
import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsProviderFilter;
import com.cloudbees.plugins.credentials.CredentialsProviderTypeRestriction;
import com.cloudbees.plugins.credentials.CredentialsProviderTypeRestrictionDescriptor;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.CredentialsStoreAction;
import com.cloudbees.plugins.credentials.CredentialsTypeFilter;
import com.cloudbees.plugins.credentials.GlobalCredentialsConfiguration;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.XmlFile;
import hudson.model.Descriptor;
import hudson.model.DescriptorVisibilityFilter;
import hudson.model.Saveable;
import hudson.security.Permission;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.GlobalConfigurationCategory;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerRequest;

@Extension
public class CredentialsProviderManager
extends DescriptorVisibilityFilter
implements Serializable,
Saveable {
    private static final Logger LOGGER = Logger.getLogger(CredentialsProviderManager.class.getName());
    private static final long serialVersionUID = 1L;
    private CredentialsProviderFilter providerFilter;
    private CredentialsTypeFilter typeFilter;
    private List<CredentialsProviderTypeRestriction> restrictions;
    private transient Map<CredentialsProviderTypeRestrictionDescriptor, List<CredentialsProviderTypeRestriction>> restrictionGroups;

    public CredentialsProviderManager() {
        try {
            XmlFile xml = CredentialsProviderManager.getConfigFile();
            if (xml.exists()) {
                xml.unmarshal((Object)this);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Failed to read the existing credentials", e);
        }
    }

    public static boolean isEnabled(CredentialsProvider provider) {
        CredentialsProviderManager manager = CredentialsProviderManager.getInstance();
        return manager == null || manager.providerFilter == null || manager.providerFilter.filter(provider);
    }

    @Nullable
    public static CredentialsProviderManager getInstance() {
        return (CredentialsProviderManager)ExtensionList.lookup(DescriptorVisibilityFilter.class).get(CredentialsProviderManager.class);
    }

    @NonNull
    public static CredentialsProviderManager getInstanceOrDie() {
        CredentialsProviderManager instance = CredentialsProviderManager.getInstance();
        if (instance == null) {
            throw new IllegalStateException("CredentialsProviderManager is not registered with Jenkins");
        }
        return instance;
    }

    public boolean filter(Object context, Descriptor descriptor) {
        Map<CredentialsProviderTypeRestrictionDescriptor, List<CredentialsProviderTypeRestriction>> restrictions = this.restrictions();
        if (restrictions != null && descriptor instanceof CredentialsDescriptor) {
            CredentialsProvider provider = null;
            if (context instanceof CredentialsProvider) {
                provider = (CredentialsProvider)((Object)context);
            } else if (context instanceof CredentialsStore) {
                provider = ((CredentialsStore)context).getProvider();
            } else if (context instanceof CredentialsStoreAction.DomainWrapper) {
                provider = ((CredentialsStoreAction.DomainWrapper)((Object)context)).getStore().getProvider();
            } else if (context instanceof CredentialsStoreAction.CredentialsWrapper) {
                provider = ((CredentialsStoreAction.CredentialsWrapper)((Object)context)).getStore().getProvider();
            }
            if (provider != null) {
                CredentialsDescriptor type = (CredentialsDescriptor)descriptor;
                for (Map.Entry<CredentialsProviderTypeRestrictionDescriptor, List<CredentialsProviderTypeRestriction>> group : restrictions.entrySet()) {
                    if (group.getKey().filter(group.getValue(), provider, type)) continue;
                    return false;
                }
            }
        }
        if (descriptor instanceof CredentialsDescriptor) {
            return this.typeFilter == null || this.typeFilter.filter((CredentialsDescriptor)descriptor);
        }
        if (descriptor instanceof CredentialsProvider && context instanceof Jenkins) {
            return this.providerFilter == null || this.providerFilter.filter((CredentialsProvider)descriptor);
        }
        return true;
    }

    public static XmlFile getConfigFile() {
        return new XmlFile(new File(Jenkins.getActiveInstance().getRootDir(), "credentials-configuration.xml"));
    }

    private void checkPermission(Permission p) {
        Jenkins.getActiveInstance().checkPermission(p);
    }

    public void save() throws IOException {
        this.checkPermission(Jenkins.ADMINISTER);
        CredentialsProviderManager.getConfigFile().write((Object)this);
    }

    @NonNull
    public CredentialsProviderFilter getProviderFilter() {
        return this.providerFilter == null ? new CredentialsProviderFilter.None() : this.providerFilter;
    }

    public void setProviderFilter(@CheckForNull CredentialsProviderFilter providerFilter) {
        if (providerFilter == null) {
            providerFilter = new CredentialsProviderFilter.None();
        }
        if (Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) && !providerFilter.equals(this.providerFilter)) {
            this.providerFilter = providerFilter;
            try {
                this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NonNull
    public CredentialsTypeFilter getTypeFilter() {
        return this.typeFilter == null ? new CredentialsTypeFilter.None() : this.typeFilter;
    }

    public void setTypeFilter(@CheckForNull CredentialsTypeFilter typeFilter) {
        if (typeFilter == null) {
            typeFilter = new CredentialsTypeFilter.None();
        }
        if (Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER) && !typeFilter.equals(this.typeFilter)) {
            this.typeFilter = typeFilter;
            try {
                this.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @NonNull
    public List<CredentialsProviderTypeRestriction> getRestrictions() {
        return this.restrictions == null ? Collections.emptyList() : Collections.unmodifiableList(this.restrictions);
    }

    public void setRestrictions(List<CredentialsProviderTypeRestriction> restrictions) {
        if (Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER)) {
            if (restrictions != null) {
                Collections.sort(restrictions, new Comparator<CredentialsProviderTypeRestriction>(){
                    final ExtensionList<CredentialsProviderTypeRestrictionDescriptor> list = ExtensionList.lookup(CredentialsProviderTypeRestrictionDescriptor.class);

                    @Override
                    public int compare(CredentialsProviderTypeRestriction o1, CredentialsProviderTypeRestriction o2) {
                        int index1 = this.list.indexOf((Object)o1.getDescriptor());
                        int index2 = this.list.indexOf((Object)o2.getDescriptor());
                        if (index1 == -1) {
                            return index2 == -1 ? 0 : 1;
                        }
                        if (index2 == -1) {
                            return -1;
                        }
                        return index1 < index2 ? -1 : (index1 == index2 ? 0 : 1);
                    }
                });
            }
            if (restrictions == null ? this.restrictions != null : !restrictions.equals(this.restrictions)) {
                this.restrictions = restrictions;
                this.restrictionGroups = null;
                try {
                    this.save();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    @CheckForNull
    private Map<CredentialsProviderTypeRestrictionDescriptor, List<CredentialsProviderTypeRestriction>> restrictions() {
        if (this.restrictionGroups == null && this.restrictions != null) {
            HashMap<CredentialsProviderTypeRestrictionDescriptor, List<CredentialsProviderTypeRestriction>> restrictionGroups = new HashMap<CredentialsProviderTypeRestrictionDescriptor, List<CredentialsProviderTypeRestriction>>();
            for (CredentialsProviderTypeRestriction restriction : this.restrictions) {
                ArrayList<CredentialsProviderTypeRestriction> group = (ArrayList<CredentialsProviderTypeRestriction>)restrictionGroups.get((Object)restriction.getDescriptor());
                if (group == null) {
                    group = new ArrayList<CredentialsProviderTypeRestriction>(1);
                    restrictionGroups.put(restriction.getDescriptor(), group);
                }
                group.add(restriction);
            }
            this.restrictionGroups = restrictionGroups;
        }
        return this.restrictionGroups;
    }

    @Extension
    public static class Configuration
    extends GlobalConfiguration {
        @Restricted(value={NoExternalUse.class})
        public CredentialsProviderFilter getProviderFilter() {
            CredentialsProviderManager manager = CredentialsProviderManager.getInstance();
            return manager == null ? new CredentialsProviderFilter.None() : manager.getProviderFilter();
        }

        @Restricted(value={NoExternalUse.class})
        public void setProviderFilter(CredentialsProviderFilter providerFilter) {
            CredentialsProviderManager manager = CredentialsProviderManager.getInstance();
            if (manager != null) {
                manager.setProviderFilter(providerFilter);
            }
        }

        @Restricted(value={NoExternalUse.class})
        public CredentialsTypeFilter getTypeFilter() {
            CredentialsProviderManager manager = CredentialsProviderManager.getInstance();
            return manager == null ? new CredentialsTypeFilter.None() : manager.getTypeFilter();
        }

        @Restricted(value={NoExternalUse.class})
        public void setTypeFilter(CredentialsTypeFilter typeFilter) {
            CredentialsProviderManager manager = CredentialsProviderManager.getInstance();
            if (manager != null) {
                manager.setTypeFilter(typeFilter);
            }
        }

        @Restricted(value={NoExternalUse.class})
        public List<CredentialsProviderTypeRestriction> getRestrictions() {
            CredentialsProviderManager manager = CredentialsProviderManager.getInstance();
            return manager == null ? Collections.emptyList() : manager.getRestrictions();
        }

        @Restricted(value={NoExternalUse.class})
        public void setRestrictions(List<CredentialsProviderTypeRestriction> restrictions) {
            CredentialsProviderManager manager = CredentialsProviderManager.getInstance();
            if (manager != null) {
                manager.setRestrictions(restrictions);
            }
        }

        public boolean configure(StaplerRequest req, JSONObject json) throws Descriptor.FormException {
            if (Jenkins.getActiveInstance().hasPermission(Jenkins.ADMINISTER)) {
                if (!json.has("restrictions")) {
                    json.put("restrictions", (Object)new JSONArray());
                }
                req.bindJSON((Object)this, json);
                return super.configure(req, json);
            }
            return false;
        }

        public GlobalConfigurationCategory getCategory() {
            return GlobalConfigurationCategory.get(GlobalCredentialsConfiguration.Category.class);
        }
    }
}

