/*
 * Decompiled with CFR 0.152.
 */
package com.cloudbees.plugins.credentials.cli;

import com.cloudbees.plugins.credentials.CredentialsProvider;
import com.cloudbees.plugins.credentials.CredentialsStore;
import com.cloudbees.plugins.credentials.cli.BaseCredentialsCLICommand;
import com.cloudbees.plugins.credentials.cli.Messages;
import com.cloudbees.plugins.credentials.domains.Domain;
import hudson.Extension;
import hudson.model.Items;
import org.kohsuke.args4j.Argument;

@Extension
public class UpdateCredentialsDomainByXmlCommand
extends BaseCredentialsCLICommand {
    @Argument(metaVar="STORE", usage="Store Id", required=true)
    public CredentialsStore store;
    @Argument(metaVar="DOMAIN", usage="Domain Name", required=true, index=1)
    public String domain;

    public String getShortDescription() {
        return Messages.UpdateCredentialsDomainByXmlCommand_ShortDescription();
    }

    protected int run() throws Exception {
        this.store.checkPermission(CredentialsProvider.MANAGE_DOMAINS);
        Domain domain = UpdateCredentialsDomainByXmlCommand.getDomainByName(this.store, this.domain);
        if (domain == null) {
            this.stderr.println("No such domain");
            return 2;
        }
        Domain replacement = (Domain)Items.XSTREAM.unmarshal(UpdateCredentialsDomainByXmlCommand.safeXmlStreamReader(this.stdin));
        if (this.store.updateDomain(domain, replacement)) {
            return 0;
        }
        this.stderr.println("No change");
        return 1;
    }
}

